package com.bxm.adscounter.service.openlog.pangu.listener;

import com.bxm.adscounter.service.openlog.pangu.event.PanguArithmeticAllLogEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Pangu;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

/**
 * 缓存盘古算法日志的处理器。
 *
 * @author dll
 * @date 2021-01-21
 * @since 1.0
 */
@Slf4j
@Configuration
public class PanguArithmeticAllLogEventListener implements EventListener<PanguArithmeticAllLogEvent> {

    private final Updater updater;

    public PanguArithmeticAllLogEventListener(@Qualifier("jedisUpdaterForAlgo") Updater updater) {
        this.updater = updater;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(PanguArithmeticAllLogEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        String bidid = keyValueMap.getFirst(Pangu.Param.BIDID);
        String value = keyValueMap.getFirst(Pangu.Param.ALGOENTITY);
        updater.updateWithSelector(algorithmCtrRedis(bidid), value, 10 * 60,11);
    }

    public static KeyGenerator algorithmCtrRedis(String bidid) {
        return () -> KeyBuilder.build("ALGORITHM", "KEY", bidid);
    }
}
