package com.bxm.adscounter.service.reporting;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * 基于参数拼接的方式。
 *
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
@Configuration
public class DefaultReportingSender extends AbstractHttpReportingSender {

    public DefaultReportingSender(Properties properties) {
        super(properties);
    }

    @Override
    public String getType() {
        return ReportingConfig.TYPE_DEFAULT;
    }

    @Override
    protected String createUrl(String url, KeyValueMap keyValueMap) {
        // httpPool.get 会默认对参数编码一次，所以这里不进行编码。
        MultiValueMap<String, String> map = new LinkedMultiValueMap<>();

        boolean isIos = StringUtils.isNotBlank(keyValueMap.getFirst(Inads.Param.IDFA)) || StringUtils.isNotBlank(keyValueMap.getFirst(Inads.Param.IDFA_MD5));
        String os = isIos ? "1" : "0";
        String callbackUrl = getCallbackUrl(keyValueMap.getFirst(Inads.Param.BXMID));

        map.add("request_id",  keyValueMap.getFirst(Inads.Param.BXMID));
        map.add("plan_id", getDefault(keyValueMap.getFirst(Inads.Param.ADID)));
        map.add("os", os);
        map.add("ip", getDefault(keyValueMap.getFirst(Inads.Param.IP)));
        map.add("ua", getDefault(UrlHelper.urlEncode(keyValueMap.getFirst(Inads.Param.UA))));
        map.add("imei_md5", getDefault(keyValueMap.getFirst(Inads.Param.IMEI_MD5)));
        map.add("androidid_md5", getDefault(keyValueMap.getFirst(Inads.Param.ANDROIDID_MD5)));
        map.add("oaid", getDefault(keyValueMap.getFirst(Inads.Param.OAID)));
        map.add("oaid_md5", getDefault(keyValueMap.getFirst(Inads.Param.OAID_MD5)));
        map.add("idfa_md5", getDefault(keyValueMap.getFirst(Inads.Param.IDFA_MD5)));
        map.add("time", getDefault(keyValueMap.getFirst(Inads.Param.TIME)));
        map.add("medium_logic_id", getDefault(keyValueMap.getFirst(Inads.Param.BXMID)));
        map.add("callback", getDefault(UrlHelper.urlEncode(callbackUrl)));
        map.add("imei", getDefault(keyValueMap.getFirst(Inads.Param.IMEI)));
        map.add("androidid", getDefault(keyValueMap.getFirst(Inads.Param.ANDROIDID)));
        map.add("idfa", getDefault(keyValueMap.getFirst(Inads.Param.IDFA)));

        return UriComponentsBuilder.fromUriString(url).replaceQueryParams(map).build().toString();
    }

    @Override
    protected HttpRequestBase createHttpRequestBase(String url, KeyValueMap keyValueMap) {
        return new HttpGet(url);
    }
}
