package com.bxm.adscounter.service.reporting;

import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.context.annotation.Configuration;

/**
 * 基于宏参替换的方式。
 *
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
@Configuration
public class MacrosReportingSender extends AbstractHttpReportingSender {

    public MacrosReportingSender(Properties properties) {
        super(properties);
    }

    @Override
    public String getType() {
        return ReportingConfig.TYPE_MACROS;
    }

    @Override
    protected String createUrl(String url, KeyValueMap keyValueMap) {
        String idfa = keyValueMap.getFirst(Inads.Param.IDFA);
        String idfaMd5 = keyValueMap.getFirst(Inads.Param.IDFA_MD5);
        String gaid = keyValueMap.getFirst(Inads.Param.GAID);
        boolean isIos = StringUtils.isNotBlank(idfa) || StringUtils.isNotBlank(idfaMd5);
        String os = isIos ? "1" : "0";
        // android: 0
        // ios: 1
        String callbackUrl = getCallbackUrl(keyValueMap.getFirst(Inads.Param.BXMID));
        String timeInMillis = keyValueMap.getFirst(Inads.Param.TIME);
        long timeInSec = NumberUtils.toLong(timeInMillis) / 1000;

        String deviceId = isIos ? idfa : gaid;

        return url.replaceAll("__REQUEST_ID__", getDefault(keyValueMap.getFirst(Inads.Param.BXMID)))
                .replaceAll("__PLAN_ID__", getDefault(keyValueMap.getFirst(Inads.Param.ADID)))
                .replaceAll("__IMEI__", getDefault(keyValueMap.getFirst(Inads.Param.IMEI)))
                .replaceAll("__IDFA__", getDefault(keyValueMap.getFirst(Inads.Param.IDFA)))
                .replaceAll("__OAID__", getDefault(keyValueMap.getFirst(Inads.Param.OAID)))
                .replaceAll("__OAID_MD5__", getDefault(keyValueMap.getFirst(Inads.Param.OAID_MD5)))
                .replaceAll("__OS__", os)
                .replaceAll("__IP__", getDefault(keyValueMap.getFirst(Inads.Param.IP)))
                .replaceAll("__UA__", getDefault(UrlHelper.urlEncode(keyValueMap.getFirst(Inads.Param.UA))))
                .replaceAll("__CALLBACK__", getDefault(UrlHelper.urlEncode(callbackUrl)))
                .replaceAll("__TIME__", getDefault(timeInMillis))
                .replaceAll("__TIME_SEC__", getDefault(timeInSec > 0 ? timeInSec : null))
                .replaceAll("__ANDROID_ID__", getDefault(keyValueMap.getFirst(Inads.Param.ANDROIDID)))
                .replaceAll("__MEDIUM_LOGIC_ID__", getDefault(keyValueMap.getFirst(Inads.Param.BXMID)))
                .replaceAll("__IMEI_MD5__", getDefault(keyValueMap.getFirst(Inads.Param.IMEI_MD5)))
                .replaceAll("__IDFA_MD5__", getDefault(keyValueMap.getFirst(Inads.Param.IDFA_MD5)))
                .replaceAll("__ANDROID_ID_MD5__", getDefault(keyValueMap.getFirst(Inads.Param.ANDROIDID_MD5)))
                .replaceAll("__GAID__", getDefault(keyValueMap.getFirst(Inads.Param.GAID)))
                .replaceAll("__GAID_MD5__", getDefault(keyValueMap.getFirst(Inads.Param.GAID_MD5)))
                .replaceAll("__DEVICE_ID__", getDefault(deviceId))
                .replaceAll("__SITE_ID__", getDefault(keyValueMap.getFirst(Inads.Param.TAGID)));
    }

    @Override
    protected HttpRequestBase createHttpRequestBase(String url, KeyValueMap keyValueMap) {
        return new HttpGet(url);
    }
}
