package com.bxm.adscounter.service.reporting;

import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

/**
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
@Configuration
public class RedisReportingConfigurer implements ReportingConfigurer {

    private final Fetcher fetcher;
    private final Updater updater;

    public RedisReportingConfigurer(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public ReportingConfig get(String adid) {
        return fetcher.hfetch(hashKey(), adid, ReportingConfig.class);
    }

    @Override
    public void set(String adid, ReportingConfig config) {
        updater.hupdate(hashKey(), adid, config);
    }

    @Override
    public Map<String, ReportingConfig> getAll() {
        return fetcher.hfetchall(hashKey(), ReportingConfig.class);
    }

    private KeyGenerator hashKey() {
        return () -> KeyBuilder.build("adscounter", "reporting", "config");
    }
}
