package com.bxm.adscounter.service.reporting;

import java.util.Map;

/**
 * 上报配置服务。
 *
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
public interface ReportingConfigurer {

    /**
     * 根据指定 adid 获取上报配置
     * @param adid 广告ID
     * @return 上报配置
     */
    ReportingConfig get(String adid);

    /**
     * 设置指定 adid 的上报配置
     * @param adid 广告ID
     * @param config 上报配置
     */
    void set(String adid, ReportingConfig config);

    /**
     * 获取所有已配置的上报配置
     * @return key 是广告ID，value 是配置。
     */
    Map<String, ReportingConfig> getAll();
}
