package com.bxm.adscounter.service.reporting;

import com.bxm.openlog.sdk.KeyValueMap;

import java.util.function.Function;

/**
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
public interface ReportingSender {

    /**
     * 上报发送者类型。
     * @return 类型
     * @see ReportingConfig#TYPE_DEFAULT
     * @see ReportingConfig#TYPE_MACROS
     */
    String getType();

    /**
     * 上报点击到指定 {@code url}
     * @param url URL
     * @param keyValueMap 日志
     */
    boolean send(String url, KeyValueMap keyValueMap);

    /**
     * 上报点击到指定 {@code url}
     * @param url URL
     * @param keyValueMap 日志
     * @param changeUrl 更改最终URL
     */
    boolean send(String url, KeyValueMap keyValueMap, Function<String, String> changeUrl);
}
