package com.bxm.adscounter.service.reporting;

import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author allen
 * @date 2022-05-30
 * @since 1.0
 */
@Configuration
public class SlsReportingSender implements ReportingLogger {

    private final CustomLoggingWriter writer;

    public SlsReportingSender(@Qualifier("customLoggingWriterForAdClickReporting") CustomLoggingWriter writer) {
        this.writer = writer;
    }

    @Override
    public void collect(String url, int sc, String body, Throwable throwable) {
        if (StringUtils.isBlank(url)) {
            return;
        }
        UriComponents build = UriComponentsBuilder.fromUriString(url).build();

        MultiValueMap<String, String> params = build.getQueryParams();

        Map<String, String> writeParams = Maps.newHashMap();

        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            List<String> list = entry.getValue();
            if (CollectionUtils.isNotEmpty(list)) {
                writeParams.put(entry.getKey(), list.get(0));
            }
        }

        writeParams.put("url", url);
        writeParams.put("statusCode", TypeHelper.castToString(sc));
        writeParams.put("responseBody", body);
        if (Objects.nonNull(throwable)) {
            writeParams.put("exception", throwable.getMessage());
        }

        writer.write(writeParams);
    }
}
