package com.bxm.adscounter.service.ticket;

import com.bxm.adscounter.facade.KuaishouTrackerService;
import com.bxm.adscounter.facade.model.kuaishou.KuaishouTrackerDto;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.KeyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * https://www.yuque.com/bxmdocs/dbah2g/pez5yo
 * @author allen
 * @date 2021-09-15
 * @since 1.0
 */
@Slf4j
@RestController
public class KuaishouTrackerServiceImpl implements KuaishouTrackerService {

    private final Fetcher fetcher;
    private final Updater updater;

    public KuaishouTrackerServiceImpl(Fetcher fetcher, @Qualifier("jedisUpdater") Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    // ---------------------------------------------------------------------- //
    // 如果改动这里，请同步修改：
    // com.bxm.adscounter.api.ticket.kuaishou.KuaishouTrackerController
    // @Allen 2022/6/15
    // ---------------------------------------------------------------------- //

    @Override
    public void clickTracker(@RequestBody KuaishouTrackerDto kuaishouTrackerDto) {
        String callback = kuaishouTrackerDto.getCallback();
        if (StringUtils.isBlank(callback)) {
            log.info("Empty value for callback!");
            return;
        }
        String url = UrlHelper.urlDecode(callback);
        String cbvalue = UrlHelper.getFirstValueOfParamName(url, "callback");
        if (StringUtils.isBlank(cbvalue)) {
            log.info("Cannot found value of callback at url {}", url);
            return;
        }
        updater.update(key(cbvalue), kuaishouTrackerDto, 10 * 60);

        if (log.isDebugEnabled()) {
            log.debug("Updated: {}", cbvalue);
        }
    }

    @Override
    public KuaishouTrackerDto getTrackerDto(@RequestParam("callback") String callback) {
        return fetcher.fetch(key(callback), KuaishouTrackerDto.class);
    }

    private KeyGenerator key(String cbvalue) {
        return () -> KeyBuilder.build("tracker", "kuaishou", cbvalue);
    }
}
