package com.bxm.adscounter.service.ticket;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;

import com.bxm.adscounter.facade.SspUserFacadeService;
import com.bxm.adscounter.facade.model.SspUserData;
import com.bxm.adscounter.service.SspUserService;

/**
 * ssp用户信息<br/>
 *
 * @author kerry.jiang
 * @date 2021/9/9 18:13
 */
@RestController
public class SspUserFacadeServiceImpl implements SspUserFacadeService {

    private final SspUserService sspUserService;

    public SspUserFacadeServiceImpl(SspUserService sspUserService) {
        this.sspUserService = sspUserService;
    }

    @Override
    public List<SspUserData> getUserData(String appId, String positionId, String[] cuids, String date) {
        if(StringUtils.isBlank(positionId)){
            return sspUserService.getActivityJoinByAppId(appId, cuids, date);
        }else{
            return sspUserService.getActivityJoinByAppId(appId, positionId, cuids, date);
        }
    }
}
