package com.bxm.adscounter.service.utils;

import com.google.common.collect.Lists;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class DateUtils {
    /**
     * 获取今天剩余秒数
     *
     * @return
     */
    public static long getDayRemainingTime() {
        LocalDateTime midnight = LocalDateTime.now().plusDays(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long seconds = ChronoUnit.SECONDS.between(LocalDateTime.now(), midnight);
        return seconds;
    }

    private final static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    /**
     * 返回当前时间往前推 cycle 天的日期集合
     *
     * @param cycle
     * @return List<String>
     * @throws
     * @author kk.xie
     * @date 2018/6/6 11:52
     */
    public static List<String> getSeveralDateList(int cycle){
        List<String> result = Lists.newArrayList();
        for(int i = 0; i<cycle ; i++){
            LocalDate localDate = LocalDate.now().minusDays(i);
            String date = getData(localDate);
            result.add(date);
        }
        return result;
    }

    /**
     * 获取当前日期为周期第一天之后的所有周期内的日期
     * @param cycle
     * @return
     */
    public static List<String> getSeveralDateListLater(int cycle){
        List<String> result = Lists.newArrayList();
        for(int i = 0; i<cycle ; i++){
            LocalDate localDate = LocalDate.now().plusDays(i);
            String date = getData(localDate);
            result.add(date);
        }
        return result;
    }

    private static String getData(LocalDate localDate) {
        return dateTimeFormatter.format(localDate);
    }
}
