package com.bxm.adscounter.service.utils;

import com.bxm.adscounter.facade.mt.Mt;
import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.EffectEndpoint;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.consts.Inads;
import com.bxm.openlog.sdk.params.ProductionCommonParam;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

/**
 * @author allen
 * @date 2022-02-28
 * @since 1.0
 */
public class GeneralEndpointUtils {

    public static EffectEndpoint fromInads(KeyValueMap map, int defaultConversionType) {
        EffectEndpoint e = new EffectEndpoint();
        e.setSendEndpointToDataCenter(false);
        e.setIp(map.getFirst(Inads.Param.IP));
        e.setParam("");
        e.setPhone("");
        e.setIdCardNum("");
        e.setShopCode("");
        e.setOrderId(map.getFirst(Inads.Param.BXMID));
        e.setStatus(StringUtils.defaultIfBlank(map.getFirst(Inads.Param.CONVERSION_STATUS), "1"));
        e.setMt(Mt._7.getOriginal());
        e.setType(NumberUtils.toInt(map.getFirst(Inads.Param.CONVERSION_TYPE), defaultConversionType));

        e.setCountId(map.getFirst(Inads.Param.BXMID));
        String tagId = map.getFirst(Inads.Param.TAGID);
        if (StringUtils.isNotBlank(tagId)) {
            String[] arr = StringUtils.split(tagId, "-");
            if (arr.length >= 2) {
                e.setAppKey(arr[0]);
                e.setBusiness("ad-" + arr[1]);
            }
        }
        e.setActivityId(NumberUtils.toLong(map.getFirst(Inads.Param.ACTIVITYID)));
        e.setTicketId(NumberUtils.toLong(map.getFirst(Inads.Param.ADID)));
        e.setUid(map.getFirst(Inads.Param.UID));
        e.setAssetsId(map.getFirst(Inads.Param.CREATEID));
        e.setAppos(NumberUtils.toInt(map.getFirst(Inads.Param.OS)));
        e.setEntranceTicketId(NumberUtils.toLong(map.getFirst(Inads.Param.EN_ADID)));
        e.setEntranceAssetsId(NumberUtils.toLong(map.getFirst(Inads.Param.EN_CID)));
        e.setBidid(map.getFirst(Inads.Param.BIDID));
        e.setObidid(map.getFirst(Inads.Param.OBIDID));
        e.setAdxAppId(map.getFirst(Inads.Param.ADX_APPID));
        e.setReferrer(map.getFirst(Inads.Param.REFER));
        e.setUserAgent(map.getFirst(Inads.Param.UA));

        return e;
    }

    /**
     * 将互动广告产品线的 KeyValueMap 转化成内部使用的 GeneralEndpoint，它除了事件监听器必须使用的参数，其他的可能不会赋值。
     * 因为大部分参数是转发给数据中心，数据中心从 2022/2/28 开始对接 OpenLog，所以不需要处理这些参数。
     *
     * @param dotType DotType
     * @param map 互动广告位的KeyValueMap
     * @return 通用的端点
     */
    public static GeneralEndpoint fromInads(DotTypeEnum dotType, KeyValueMap map) {
        GeneralEndpoint e = new GeneralEndpoint();
        setMt2Endpoint(map, e);
        e.setSendEndpointToDataCenter(false);
        e.setDotType(dotType);
        e.setIp(map.getFirst(ProductionCommonParam.IP));

        String tagId = map.getFirst(Inads.Param.TAGID);
        if (StringUtils.isNotBlank(tagId)) {
            String[] arr = StringUtils.split(tagId, "-");
            if (arr.length >= 2) {
                e.setAppKey(arr[0]);
                e.setBusiness("ad-" + arr[1]);
            }
        }

        e.setSpm(map.getFirst(Inads.Param.SPM));
        e.setUid(map.getFirst(Inads.Param.UID));
        e.setAppos(NumberUtils.toInt(map.getFirst(Inads.Param.OS), 3));
        e.setApposVersion(map.getFirst(Inads.Param.OS_DETAIL));
        e.setDevm(map.getFirst(Inads.Param.DEVICE_NAME));
        e.setActivityId(NumberUtils.toLong(map.getFirst(Inads.Param.ACTIVITYID)));
        e.setTicketId(NumberUtils.toLong(map.getFirst(Inads.Param.ADID)));
        e.setAssetsId(map.getFirst(Inads.Param.CREATEID));

        e.setX(map.getFirst(Inads.Param.X));
        e.setY(map.getFirst(Inads.Param.Y));
        e.setOrigin(map.getFirst(Inads.Param.DOMAIN));
        e.setDomain(map.getFirst(Inads.Param.DOMAIN));
        e.setReferrer(map.getFirst(Inads.Param.REFER));
        e.setUserAgent(map.getFirst(Inads.Param.UA));
        e.setOrderId(map.getFirst(Inads.Param.BXMID));
        e.setExt(map.getFirst(Inads.Param.EXT));
        e.setTicketType(NumberUtils.toByte(map.getFirst(Inads.Param.ACTYPE)));
        e.setEntranceTicketId(NumberUtils.toLong(map.getFirst(Inads.Param.EN_ADID)));
        e.setEntranceAssetsId(NumberUtils.toLong(map.getFirst(Inads.Param.EN_CID)));
        e.setBidid(map.getFirst(Inads.Param.BIDID));
        e.setObidid(map.getFirst(Inads.Param.OBIDID));
        e.setAdxAppId(map.getFirst(Inads.Param.ADX_APPID));

        e.setScene(NumberUtils.toInt(map.getFirst(Inads.Param.SCENE)));
        e.setPopupId(map.getFirst(Inads.Param.POPUPID));
        e.setOfferPrice(NumberUtils.toInt(map.getFirst(Inads.Param.OFFER_PRICE)));
        e.setDirect(NumberUtils.toInt(map.getFirst(Inads.Param.SRC_TYPE)));
        e.setTimestamp(NumberUtils.toLong(map.getFirst(Inads.Param.TIME)));
        e.setIsp(map.getFirst(Inads.Param.ISP));
        e.setPosition(map.getFirst(Inads.Param.TAGID));
        e.setWokeId(map.getFirst(Inads.Param.WOKEID));
        e.setSourceType(map.getFirst(Inads.Param.SRC_TYPE));
        e.setFmid(map.getFirst(Inads.Param.FMID));
        e.setFmModelId(map.getFirst(Inads.Param.FM_MODEL_ID));

        e.setImei(map.getFirst(Inads.Param.IMEI));
        e.setImeiMd5(map.getFirst(Inads.Param.IMEI_MD5));
        e.setAnid(map.getFirst(Inads.Param.ANDROIDID));
        e.setAnidMd5(map.getFirst(Inads.Param.ANDROIDID_MD5));
        e.setOaid(map.getFirst(Inads.Param.OAID));
        e.setOaidMd5(map.getFirst(Inads.Param.OAID_MD5));
        e.setIdfa(map.getFirst(Inads.Param.IDFA));
        e.setIdfaMd5(map.getFirst(Inads.Param.IDFA_MD5));

        e.setLandId(map.getFirst(Inads.Param.LANDID));
        e.setSspAppId(map.getFirst(Inads.Param.SSP_APPID));
        e.setSspPositionId(map.getFirst(Inads.Param.SSP_TAGID));

        e.setOcpaOfferPrice(NumberUtils.toInt(map.getFirst(Inads.Param.OCPA_OFFER_PRICE)));
        e.setTargetConvType(NumberUtils.toShort(map.getFirst(Inads.Param.TARGET_CONV_TYPE)));
        e.setSettleType(NumberUtils.toByte(map.getFirst(Inads.Param.SETTLE_TYPE)));

        e.setSeq(map.getFirst(Inads.Param.SEQ));
        return e;
    }

    private static void setMt2Endpoint(KeyValueMap map, GeneralEndpoint e) {
        Inads.Mt mt = Inads.Mt.of(map.getFirst(Inads.Param.MT));
        switch (mt) {
            case IndexShow:
                e.setMt(Mt._9.getOriginal());
                break;
            case ActivityPageShow:
                e.setMt(Mt._3.getOriginal());
                break;
            case ActivityAttend:
                e.setMt(Mt._4.getOriginal());
                break;
            case AdRequest:
                e.setMt(Mt._5.getOriginal());
                break;
            case AdShow:
                e.setMt(Mt._6.getOriginal());
                break;
            case AdClick:
                e.setMt(Mt._7.getOriginal());
                break;
            default:
                throw new IllegalStateException("Unsupported mt: " + mt);
        }
    }
}
