package com.bxm.adsprod.counter.event;

import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;

import java.util.EventObject;

/**
 * 广告券点击事件
 *
 * @author allen
 * @since 1.0.0
 */
public class TicketClickEvent extends EventObject {

    private static final long serialVersionUID = -8717472713791231665L;
    private final ClickRequest request;
    private final Ticket ticket;

    public TicketClickEvent(Object source, ClickRequest request, Ticket ticket) {
        super(source);
        this.request = request;
        this.ticket = ticket;
    }

    public ClickRequest getRequest() {
        return request;
    }

    public Ticket getTicket() {
        return ticket;
    }
}
