package com.bxm.adsprod.counter.event;

import com.bxm.adsprod.facade.ticket.Ticket;

import java.util.EventObject;

/** 券消耗超过券消耗提醒触发的事件
 * @author sunzs
 * created on 2018/9/12
 */
public class TicketCostExceedCostWarnEvent extends EventObject {

    private final Ticket ticket;
    private final long val;//当前的券总消耗
    private final Double costRdis;//上次记录时的消耗
    private final String positionId;
    private final Long ticketCostId;
    /**
     * Constructs a prototypical Event.
     *
     * @param source The object on which the Event initially occurred.
     * @throws IllegalArgumentException if source is null.
     */
    public TicketCostExceedCostWarnEvent(Object source, Ticket ticket,Long val,Double costRdis,String positionId,Long ticketCostId) {
        super(source);
        this.ticket = ticket;
        this.val = val;
        this.costRdis=costRdis;
        this.positionId = positionId;
        this.ticketCostId= ticketCostId;
    }

    public Ticket getTicket() {
        return ticket;
    }

    public Long getVal() {
        return val;
    }

    public Double getCostRdis() {
        return costRdis;
    }

    public String getPositionId() {
        return positionId;
    }

    public Long getTicketCostId() {
        return ticketCostId;
    }
}
