package com.bxm.adsprod.counter.event.listeners;

import com.bxm.adsprod.counter.event.BudgetNotEnoughOfDailyEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>日预算不足事件状态变更处理</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/19
 */
@Component
public class BudgetNotEnoughOfDailyEventListener implements EventListener<BudgetNotEnoughOfDailyEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(BudgetNotEnoughOfDailyEventListener.class);

    @Autowired
    private TicketService ticketService;

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(BudgetNotEnoughOfDailyEvent event) {
        Ticket ticket =  ticketService.get(event.getTicket().getId());
        if(Ticket.STATUS_CLOSE==ticket.getStatus()){
            return;
        }
        if (!ticket.isAvailableForStatus()) {
            return;
        }

        BigInteger id = ticket.getId();

        boolean flag = ticketService.updateTicketStatus(id, Ticket.STATUS_PAUSE, Ticket.PAUSE_REASON_OUT_OF_DAILYBUDGET);

        if (flag) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("广告券({})状态(暂停-日预算不足)更新完成", id);
            }
        }
        else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("广告券({})状态(暂停-日预算不足)更新失败!", id);
            }
        }
    }
}
