package com.bxm.adsprod.counter.event.listeners;

import java.math.BigInteger;

import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bxm.adsprod.counter.event.TicketEffectClickEvent;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

/**
 * 广告券有效点击端点
 *
 * @author allen
 * @since 1.0.0
 */
@Component
public class TicketAssetsValidClickEndpointEventListener implements EventListener<TicketEffectClickEvent> {

    @Autowired
    private Counter counter;

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketEffectClickEvent event) {
        ClickRequest request = event.getRequest();
        Ticket ticket = event.getTicket();
        String position = request.getPosition();
        BigInteger assetsId = request.getAssetsId();
        String billid = request.getBillid();

        Object original = counter.getClientOriginal();
        if (original instanceof JedisPool) {
            JedisPool jedisPool = (JedisPool) original;

            Jedis jedis = jedisPool.getResource();

            try {
                if (ticket.isOldAssets()) {//互动广告的那套素材
                    jedis.pfadd(TicketKeyGenerator.Statistics.getTicketAllAssetsValidClick(position,
                            String.valueOf(assetsId)).generateKey(), billid);
                }

                // 新的素材统计
                jedis.pfadd(TicketKeyGenerator.Statistics.getTicketAllCreativeValidClick(position,
                        String.valueOf(ticket.getId()), String.valueOf(assetsId)).generateKey(),
                        billid);
            } finally {
                if (null != jedis) {
                    jedis.close();
                }
            }
        }
    }
}
