package com.bxm.adsprod.counter.ticket;

import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;

import java.math.BigInteger;

/**
 * <h3>点击次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
public abstract class AbstractClickCounter extends AbstractCounter<ClickRequest, Ticket> {

    @Override
    protected ClickRequest convertRequest(Object request) {
        return (ClickRequest) request;
    }

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        return DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected String getUid(ClickRequest clickRequest, Ticket ticket) {
        return clickRequest.getUid();
    }

    @Override
    protected BigInteger getTicketId(ClickRequest clickRequest, Ticket ticket) {
        return ticket.getId();
    }

    /**
     * 返回过期时间
     * @param day int
     * @return int
     */
    protected int getExpireTimeOfDay(int day) {
        return TypeHelper.castToInt(DateHelper.getRemainSecondsOfDay(day));
    }

}
