package com.bxm.adsprod.counter.ticket;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.ViewRequest;

import java.math.BigInteger;

/**
 * <h3>曝光次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
public abstract class AbstractViewCounter extends AbstractCounter<ViewRequest, Ticket> {

    @Override
    protected ViewRequest convertRequest(Object request) {
        return (ViewRequest) request;
    }

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected String getUid(ViewRequest ticketRequest, Ticket ticket) {
        return ticketRequest.getUid();
    }

    @Override
    protected BigInteger getTicketId(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.getId();
    }
}
