package com.bxm.adsprod.counter.ticket.cashier;

import com.bxm.adsprod.counter.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import java.math.BigInteger;

/**
 * 基于老平台的数据进行广告主余额结算
 *
 * @author allen
 * @since 1.0.0
 */
@Configuration
public class RemoteAdvertiserCashier extends AdvertiserCashier implements EventListener<TicketClickEvent> {

    private final EventPark eventPark;

    @Autowired
    private AdvertiserService advertiserService;

    public RemoteAdvertiserCashier(EventPark eventPark) {
        this.eventPark = eventPark;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected void afterConsume(ClickRequest request, Ticket ticket, long inc, long afterInc) {
        // 0. 只有CPC的券和常规券才需要结算
        boolean isNeededSettle = (null != ticket.getType() && ticket.getType() == Ticket.TYPE_NORMAL) && ticket.isAutoSettleType();
        if (!isNeededSettle) {
            return;
        }

        BigInteger adid = ticket.getAdvertiser();
        if (null == adid) {
            return;
        }
        Long balance = advertiserService.getAdvertiserBalance(adid);
        if (balance <= 0) {
            // 余额不足
            eventPark.post(new BalanceNotEnoughEvent(this, ticket));
        }
    }
}
