package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigInteger;

/**
 * @author 拉拉
 * @version v1.1.4_Ticket
 * @fileName com.bxm.adsprod.counter.ticket.counter.TicketAssetsViewCounter.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-03-26 11:17:00
 * @modifier 拉拉
 * @updated 2018-03-26 11:17:00
 */
@Component
@Slf4j
public class TicketAssetsClickCounter extends AbstractClickCounter implements HashCounter, EventListener<TicketClickEvent> {

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    @Override
    protected KeyGenerator getKeyGenerator(ClickRequest clickRequest, Ticket ticket) {
        if (!clickRequest.isValid()) {
            return TicketKeyGenerator.Statistics.getTicketAllAssetsClick(clickRequest.getPosition());
        } else {
            //这个是统计有效点击的
            return null;//这里的key目前不会被使用，关注方法：isIncrementIfNeeded()
//            return TicketKeyGenerator.Statistics.getTicketDailyAssetsValidClick();
        }
    }

    @Override
    protected boolean isIncrementIfNeeded(ClickRequest clickRequest, Ticket ticket) {
        return null != clickRequest.getAssetsId() && !clickRequest.isValid();
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ClickRequest clickRequest = convertRequest(request);
        return clickRequest.getAssetsId().toString();
    }

    @Override
    protected void afterIncrement(long val, ClickRequest request, Ticket ticket) {
        if (!request.isValid()) {
            //正常的素材点击，要累加到每天
            BigInteger assetsId = request.getAssetsId();
            if (null == assetsId) {
                return;
            }
            if (ticket.isOldAssets()) {//互动广告的那套素材
                counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getTicketDailyAssetsClick(),
                        assetsId.toString(), DEFAULT_INCREMENT_VALUE, getExpireTimeInSeconds());
            }
            //新的素材统计
            counter.hincrementByAndGet(TicketKeyGenerator.Statistics.getTicketDailyCreativeClick(ticket.getId().toString()),
                    assetsId.toString(), DEFAULT_INCREMENT_VALUE, getExpireTimeInSeconds());
        } else {
            BigInteger assetsId = request.getAssetsId();
            if (null == assetsId) {
                return;
            }
            Object clientOriginal = super.counter.getClientOriginal();
            if (clientOriginal instanceof JedisPool) {
                JedisPool jedisPool = (JedisPool) clientOriginal;

                //新的素材统计
                KeyGenerator keyNew = TicketKeyGenerator.Statistics.getTicketDailyCreativeValidClick(ticket.getId().toString(), assetsId.toString());

                Jedis jedis = null;
                try {
                    jedis = jedisPool.getResource();

                    if (ticket.isOldAssets()) {//互动广告的那套素材
                        KeyGenerator keyOld = TicketKeyGenerator.Statistics.getTicketDailyAssetsValidClick(assetsId.toString());
                        jedis.pfadd(keyOld.generateKey(), request.getBillid());
                        //过期时间设置为两天
                        jedis.expire(keyOld.generateKey(), getExpireTimeOfDay(2));
                    }

                    jedis.pfadd(keyNew.generateKey(), request.getBillid());
                    //过期时间设置为两天
                    jedis.expire(keyNew.generateKey(), getExpireTimeOfDay(2));

                    if(null != request.getEntrTicketId()){
                        if(null != request.getEntrAssetsId()){
                            String keyPanGu = TicketKeyGenerator.Statistics.getPanGuTicketDailyCreativeValidClick(
                                    request.getEntrTicketId().toString(),
                                    request.getEntrAssetsId().toString()).generateKey();
                            jedis.pfadd(keyPanGu, request.getBillid());
                            //过期时间设置为两天
                            jedis.expire(keyPanGu, getExpireTimeOfDay(2));
                        }else{
                            log.warn("getPanGuTicketDailyCreativeValidClick warn: entrTicketId={},entrAssetsId={}",
                                    request.getEntrTicketId(), request.getEntrAssetsId());
                        }

                    }
                } catch (Exception e) {
                    log.error("实时统计素材有效点击报错" + e.getMessage(), e);
                } finally {
                    if (null != jedis) {
                        jedis.close();
                    }
                }
            }
        }
    }
}
