package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.CounterRequest;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>日曝光次数统计</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
public class TicketDailyViewCounter extends AbstractViewCounter implements HashCounter, EventListener<TicketViewEvent> {

	@Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getViewOfDaily();
    }
    
	@Override
	public <T extends CounterRequest> String getField(T request) {
		ViewRequest view = convertRequest(request);
		return String.valueOf(view.getTicketId());
	}

	@Override
	@Subscribe
	@AllowConcurrentEvents
	public void consume(TicketViewEvent event) {
		super.consume(event.getRequest(), event.getTicket());
	}
}
