package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.*;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>CPA 广告券每小时预算统计器</h3>
 * <p>当该广告券的时间段预算不足时，会将该广告券的状态更新为暂停</p>
 *
 * @author allen
 * @since V1.0.0 2017/12/11
 */
@Component
public class TicketForCpaHourlyBudgetCounter extends AbstractViewCounter implements HashCounter, EventListener<TicketViewEvent> {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private EventPark eventPark;
    @Autowired
    private TicketStatisticsService ticketStatisticsService;

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
	public <T extends CounterRequest> String getField(T request) {
		ViewRequest view = convertRequest(request);
		return String.valueOf(view.getTicketId());
	}

    @Override
    protected long getIncrementValue(ViewRequest ticketRequest, Ticket ticket) {
        return ticket.isAutoSettleType() ? 0 : DEFAULT_INCREMENT_VALUE;
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfHourly();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest viewRequest, Ticket ticket) {
        CounterUtils.doBudgetOfHourly(this, ticketStatisticsService, fetcher, eventPark, ticket);
    }
}
