package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.ticket.AbstractClickCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.counter.ticket.counter.utils.CounterUtils;
import com.bxm.adsprod.facade.ticket.*;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>CPC 广告券每小时预算统计器</h3>
 * <p>当该广告券的时间段预算不足时，会将该广告券的状态更新为暂停</p>
 * @author allen
 * @since V1.0.0 2017/12/11
 */
@Component
public class TicketForCpcHourlyBudgetCounter extends AbstractClickCounter implements HashCounter, EventListener<TicketClickEvent> {

    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    private EventPark eventPark;
    @Autowired
    private TicketStatisticsService ticketStatisticsService;

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
	public <T extends CounterRequest> String getField(T request) {
		ClickRequest click = convertRequest(request);
		return String.valueOf(click.getTicketId());
	}

    @Override
    protected long getIncrementValue(ClickRequest clickRequest, Ticket ticket) {
        //有效点击但不是ocpa的券   或者 ocpa的券，已扣费（点击的时候都当做已扣费），都不算价格
        if ((clickRequest.isValid() && !ticket.isOCPA())
                ||  (ticket.isOCPA() && clickRequest.isCost())) {
            return 0;
        }
        //当是ocpa 并且是有效点击，并且类型对的上的时候,也没产生扣费过 开始计算价格
        if(clickRequest.isValid() && ticket.isOCPA() && !clickRequest.isCost()){
            return ticket.getCpaPrice();
        }
        Integer offerPrice = ticket.getOfferPrice();
        return (ticket.isAutoSettleType() ? (null == offerPrice) ? ticket.getPrice() : offerPrice : 0);
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return TicketKeyGenerator.Statistics.getBudgetOfHourly();
    }

    @Override
    protected void afterIncrement(long val, ClickRequest clickRequest, Ticket ticket) {
        CounterUtils.doBudgetOfHourly(this, ticketStatisticsService, fetcher, eventPark, ticket);
    }

}
