package com.bxm.adsprod.counter.ticket.counter;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.counter.ticket.AbstractViewCounter;
import com.bxm.adsprod.counter.ticket.HashCounter;
import com.bxm.adsprod.facade.ticket.*;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.math.BigInteger;

/**
 * 广告组频次曝光限制、
 *
 * @author 阿导
 * @version 1.0
 * @fileName com.bxm.adsprod.counter.ticket.counter.TicketGroupViewCounter.java
 * @CopyRright (c) 2018-万物皆导
 * @created 2018-03-27 14:54:00
 */
@Component
public class TicketGroupDailyViewCounter extends AbstractViewCounter implements HashCounter, EventListener<TicketViewEvent> {

    @Autowired
    private Fetcher fetcher;
    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        super.consume(event.getRequest(), event.getTicket());
    }

    @Override
    protected KeyGenerator getKeyGenerator(String uid, BigInteger ticketId) {
        return null;
    }

    /**
     * 返回存储需要的KeyGenerator实现，可以覆盖这个方法。
     *
     * @param viewRequest
     * @param ticket
     * @return
     * @see #getKeyGenerator(String, BigInteger)
     */
    @Override
    protected KeyGenerator getKeyGenerator(ViewRequest viewRequest, Ticket ticket) {
        Long groupId = ticket.getGroupId();
        return TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey(groupId);
    }

    @Override
    public <T extends CounterRequest> String getField(T request) {
        ViewRequest view = convertRequest(request);
        return view.getUid();
    }

    /**
     * 返回过期时间，默认为10天
     *
     * @return
     */
    @Override
    protected int getExpireTimeInSeconds() {
        return 24 * 60 * 60;
    }

    @Override
    protected boolean isIncrementIfNeeded(ViewRequest clickRequest, Ticket ticket) {
        return null != ticket.getGroupId();
    }

    @Override
    protected void afterIncrement(long val, ViewRequest request, Ticket ticket) {
        processAdx(val, request, ticket);
        Long groupId = ticket.getGroupId();
        if (null == groupId) {
            return;
        }

        TicketGroupPushVo vo = fetcher.fetch(TicketKeyGenerator.Filter.getTicketGroup(BigInteger.valueOf(groupId)), TicketGroupPushVo.class);
        if (!vo.isEnabled()) {
            return;
        }
        String uid = request.getUid();

        Integer openFrequency = vo.getOpenFrequency();
        if (null != openFrequency && openFrequency.equals(TicketGroupPushVo.EVERY_DAY)) {
            Integer current = fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey(groupId), uid, Integer.class);
            Integer openFrequencyNum = vo.getOpenFrequencyNum();
            if (null != current && null != openFrequencyNum && current >= openFrequencyNum) {
                // Closed
                updater.supdate(TicketKeyGenerator.User.getClosedGroup(uid), 24 * 60 * 60, String.valueOf(groupId));
            }
        }
    }

    private void processAdx(long val, ViewRequest request, Ticket ticket) {
        Long groupId = ticket.getGroupId();
        if (null == groupId) {
            return;
        }

        TicketGroupPushVo vo = fetcher.fetch(TicketKeyGenerator.Filter.getTicketGroup(BigInteger.valueOf(groupId)), TicketGroupPushVo.class);
        if (!vo.isEnabled()) {
            return;
        }
        String uid = request.getUid();
        if (StringUtils.isEmpty(uid)) {
            return;
        }
        Integer openFrequency = vo.getOpenFrequency();
        if (null != openFrequency && openFrequency.equals(TicketGroupPushVo.EVERY_DAY)) {
            Integer current = fetcher.hfetch(TicketKeyGenerator.Statistics.getTicketGroupDailyViewKey(groupId), uid, Integer.class);
            Integer openFrequencyNum = vo.getOpenFrequencyNum();
            if (null != current && null != openFrequencyNum && current >= openFrequencyNum) {
                // Closed
                KeyGenerator key = TicketKeyGenerator.User.getClosedTicketByUid(uid);
                updater.supdate(key, 24 * 60 * 60, String.valueOf(ticket.getId()));
            }
        }
    }
}
