package com.bxm.adsprod.counter.ticket.counter.utils;

import com.bxm.adsprod.counter.event.BudgetNotEnoughOfHourlyEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.model.so.rules.TicketTimelineRuleSo;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.EventPark;

import java.util.Calendar;
import java.util.List;

/**
 * @author allen
 * @since 1.0.0
 */
public final class CounterUtils {

    private CounterUtils() {}

    /**
     * 处理每个时间段的预算，如果当前时间的预算不足，那么会发送相应的事件。
     *
     * @param source
     * @param ticketStatisticsService
     * @param fetcher
     * @param eventPark
     * @param ticket
     */
    public static void doBudgetOfHourly(Object source, TicketStatisticsService ticketStatisticsService, Fetcher fetcher, EventPark eventPark, Ticket ticket) {
        if (null == source) {
            return;
        }
        if (null == fetcher) {
            return;
        }
        if (null == eventPark) {
            return;
        }
        if (null == ticket) {
            return;
        }
        TicketTimelineRuleSo config = fetcher.fetch(TicketKeyGenerator.Filter.getTimeline(ticket.getId()), null, TicketTimelineRuleSo.class);
        if (null == config) {
            return;
        }
        int currentHour = Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
        List<TicketTimelineRuleSo.Entry> rules = config.getEntries();
        for (TicketTimelineRuleSo.Entry rule : rules) {
            int startHour = rule.getStartHour();
            int endHour = rule.getEndHour();
            long max = rule.getLimit();
            boolean isTimeNow = currentHour >= startHour && currentHour < endHour;
            if (isTimeNow) {
                // 判断当前时间段是否超出限额
                long budgetOfTimeline = ticketStatisticsService.getBudgetOfTimeline(ticket.getId(), startHour, endHour);
                if (budgetOfTimeline >= max) {
                    eventPark.post(new BudgetNotEnoughOfHourlyEvent(source, ticket, currentHour, startHour, endHour));
                }
                return;
            }
        }

        // 当前时间不在指定时间内，需要关闭广告券。
        eventPark.post(new BudgetNotEnoughOfHourlyEvent(source, ticket));
    }
}
