package com.bxm.adsprod.counter.ticket.recorder;

import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.facade.ticket.Scene;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.TypeHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

/**
 * <h3>用户最后获得的广告券记录器</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@Component
public class UserLastTicketRecorder implements EventListener<TicketViewEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserLastTicketRecorder.class);
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketViewEvent event) {
        this.setLastAcquireTicket(event.getTicket(), event.getRequest().getUid());
    }

    private void setLastAcquireTicket(Ticket ticket, String uid) {
        if (null == ticket) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("ticket is null.");
            }
            return;
        }
        if (StringUtils.isBlank(uid)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("uid is null.");
            }
            return;
        }
        //如果是激励券，则不进入最后一次出券，不然如果下一次出的券和激励券类型相同，则不会出
        if (ticket.getType() == Ticket.TYPE_REWARD){
            return;
        }
        Integer expire = TypeHelper.castToInt(DateHelper.getRemainSecondsOfToday());
        updater.update(TicketKeyGenerator.User.getUser(uid), ticket, expire);
        // 设置场景记录
        Set<String> alreadys = fetcher.fetch(TicketKeyGenerator.Scene.getSceneViews(Scene.POPUP, uid), null, Set.class);
        if (null == alreadys) {
            alreadys = new HashSet<String>();
        }
        alreadys.add(String.valueOf(ticket.getId()));
        updater.update(TicketKeyGenerator.Scene.getSceneViews(Scene.POPUP, uid), alreadys, expire);
    }
}
