package com.bxm.adsprod.counter.user;

import com.bxm.adsprod.counter.utils.AdsServiceDateHelper;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.math.BigInteger;
import java.util.List;

/**
 * @author allen
 * @since V1.0.0 2017/12/08
 */
@org.springframework.stereotype.Service
public class UserStatisticsServiceImpl implements UserStatisticsService {

    @Autowired
    @Qualifier("jedisCounter")
    private Counter counter;

    @Override
    public long countViewOfToday(String uid, BigInteger ticketId) {
        KeyGenerator viewOfDaily = TicketKeyGenerator.Statistics.getViewOfDaily(ticketId);
        Long count = counter.hget(viewOfDaily, uid);
        return getLongIgnoreNull(count);
    }

    @Override
    public long countClickOfToday(String uid, BigInteger ticketId) {
        KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getClickOfDaily(ticketId);
        Long count = counter.hget(clickOfDaily, uid);
        return getLongIgnoreNull(count);
    }

    @Override
    public long countViewOfThisWeek(String uid, BigInteger ticketId) {
        KeyGenerator viewOfWeekly = TicketKeyGenerator.Statistics.getViewOfWeekly(ticketId);
        Long count = counter.hget(viewOfWeekly, uid);
        return getLongIgnoreNull(count);
    }

    @Override
    public long countClickOfThisWeek(String uid, BigInteger ticketId) {
        KeyGenerator clickOfWeekly = TicketKeyGenerator.Statistics.getClickOfWeekly(ticketId);
        Long count = counter.hget(clickOfWeekly, uid);
        return getLongIgnoreNull(count);
    }

    @Override
    public long countViewOfSeveralDays(String uid, BigInteger ticketId, int cycle) {
        List<String> dateList = AdsServiceDateHelper.getSeveralDateList(cycle);
        long count = 0L;
        for(String date : dateList){
            KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getViewOfDaily(date, ticketId);
            count += counter.hget(clickOfDaily, uid);
        }
        return count;
    }

    @Override
    public long countClickOfSeveralDays(String uid, BigInteger ticketId, int cycle) {
        List<String> dateList = AdsServiceDateHelper.getSeveralDateList(cycle);
        long count = 0L;
        for(String date : dateList){
            KeyGenerator clickOfDaily = TicketKeyGenerator.Statistics.getClickOfDaily(date, ticketId);
            count += counter.hget(clickOfDaily, uid);
        }

        return count;
    }

    private long getLongIgnoreNull(Long count) {
        return null == count ? 0 : count;
    }
}
