package com.bxm.adsprod.counter.utils;

import com.google.common.collect.Lists;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * 时间工具类
 *
 * @ClassName AdsServiceDateHelper
 * @CopyRright (c) 2018-bxm：杭州微财网络科技有限公司
 * @Author kk.xie
 * @Date 2018/6/6 11:36
 * @Version 1.0
 * @Modifier kk.xie
 * @Modify Date 2018/6/6 11:36
 **/
public class AdsServiceDateHelper {
    private final static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    /**
     * 返回当前时间往前推 cycle 天的日期集合
     *
     * @param cycle
     * @return List<String>
     * @throws
     * @author kk.xie
     * @date 2018/6/6 11:52
     */
    public static List<String> getSeveralDateList(int cycle){
        List<String> result = Lists.newArrayList();
        for(int i = 0; i<cycle ; i++){
            LocalDate localDate = LocalDate.now().minusDays(i);
            String date = getData(localDate);
            result.add(date);
        }
        return result;
    }

    /**
     * 获取当前日期为周期第一天之后的所有周期内的日期
     * @param cycle
     * @return
     */
    public static List<String> getSeveralDateListLater(int cycle){
        List<String> result = Lists.newArrayList();
        for(int i = 0; i<cycle ; i++){
            LocalDate localDate = LocalDate.now().plusDays(i);
            String date = getData(localDate);
            result.add(date);
        }
        return result;
    }

    private static String getData(LocalDate localDate) {
        return dateTimeFormatter.format(localDate);
    }
}
