/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.autoconfigure;

import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisClient.class);
    @Autowired
    @Qualifier(value="jedisPool")
    private JedisPool jedisPool;
    @Autowired
    @Qualifier(value="jedisPoolOld")
    private JedisPool jedisPoolOld;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pfadd(KeyGenerator keyGenerator, String value, Integer dbIndex) {
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient] pfadd the key is null ======");
            return null;
        }
        Jedis jedis = null;
        Long count = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            count = jedis.pfadd(key, new String[]{value});
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient] pfadd error ======", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(KeyGenerator keyGenerator, int expireTimeInSecond, Integer dbIndex) {
        Preconditions.checkNotNull((Object)keyGenerator);
        String key = keyGenerator.generateKey();
        if (expireTimeInSecond > 0) {
            Jedis jedis = null;
            try {
                jedis = this.jedisPool.getResource();
                if (null != dbIndex && dbIndex >= 0) {
                    jedis.select(dbIndex.intValue());
                }
                jedis.expire(key, expireTimeInSecond);
            }
            catch (Exception e) {
                LOGGER.error("[RedisClient] expire error ======", (Throwable)e);
            }
            finally {
                if (null != jedis) {
                    jedis.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hincrBy(KeyGenerator keyGenerator, String field, int incr_by_number, Integer dbIndex) {
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient] hincrBy the key is null ======");
            return null;
        }
        Jedis jedis = null;
        Long result = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.hincrBy(key, field, (long)incr_by_number);
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient] hincrBy error ======", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return result;
    }

    public Long incr(KeyGenerator keyGenerator, Integer dbIndex) {
        return this.incr(keyGenerator, dbIndex, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(KeyGenerator keyGenerator, Integer dbIndex, Integer expire) {
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient] incr the key is null ======");
            return null;
        }
        Jedis jedis = null;
        Long result = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.incr(key);
            if (null != expire && expire >= 0) {
                jedis.expire(key, expire.intValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient] incr error ======", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(KeyGenerator keyGenerator, Integer dbIndex) {
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient] get the key is null ======");
            return null;
        }
        Jedis jedis = null;
        String result = null;
        try {
            jedis = this.jedisPool.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.get(key);
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient] get ERROR ======", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToOldRedis(KeyGenerator keyGenerator, String value, Integer dbIndex, Integer expire) {
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient setToOldRedis] the key is null ======");
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPoolOld.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            jedis.set(key, value);
            if (null != expire && expire > 0) {
                jedis.expire(key, expire.intValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient setToOldRedis] error ======", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFromOldRedis(KeyGenerator keyGenerator, Integer dbIndex) {
        String key = keyGenerator.generateKey();
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient getFromOldRedis] the key is null ======");
            return null;
        }
        Jedis jedis = null;
        String result = null;
        try {
            jedis = this.jedisPoolOld.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.get(key);
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient getFromOldRedis] ERROR ======", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sAddToOldRedis(String key, String value, Integer dbIndex, Integer expire) {
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient] sAddToOldRedis the key is null ======");
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPoolOld.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            jedis.sadd(key, new String[]{value});
            if (null != expire && expire >= 0) {
                jedis.expire(key, expire.intValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient]sAddToOldRedis ERROR", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pfaddToOldRedis(String key, String value, Integer dbIndex, Integer expire) {
        if (StringUtils.isBlank((CharSequence)key)) {
            LOGGER.error("[RedisClient] pfaddToOldRedis the key is null ======");
            return;
        }
        Jedis jedis = null;
        try {
            jedis = this.jedisPoolOld.getResource();
            if (null != dbIndex && dbIndex >= 0) {
                jedis.select(dbIndex.intValue());
            }
            jedis.pfadd(key, new String[]{value});
            if (null != expire && expire >= 0) {
                jedis.expire(key, expire.intValue());
            }
        }
        catch (Exception e) {
            LOGGER.error("[RedisClient] pfaddToOldRedis error ======", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

