/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.autoconfigure;

import com.bxm.adscounter.facade.KuaishouTrackerService;
import com.bxm.adscounter.facade.model.kuaishou.KuaishouTrackerDto;
import com.bxm.adscounter.integration.RtbConversion;
import com.bxm.adscounter.integration.RtbConversionRequest;
import com.bxm.adscounter.integration.RtbConversionResponse;
import com.bxm.adscounter.integration.aop.InvokeInterceptor;
import com.bxm.adscounter.integration.aop.RtbConversionAspect;
import com.bxm.adscounter.model.EffectEndpoint;
import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.extension.client.Fallback;
import com.bxm.openlog.extension.client.OpenLogClient;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RtbConversionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RtbConversionAutoConfiguration.class);
    private final Properties properties;
    private final KuaishouTrackerService kuaishouTrackerService;

    public RtbConversionAutoConfiguration(Properties properties, KuaishouTrackerService kuaishouTrackerService) {
        this.properties = properties;
        this.kuaishouTrackerService = kuaishouTrackerService;
    }

    @Bean
    public RtbConversionAspect rtbConversionAspect(final OpenLogClient openLogClient) {
        return new RtbConversionAspect(new InvokeInterceptor(){

            public void intercept(RtbConversion target, RtbConversionRequest request, RtbConversionResponse response) {
                EffectEndpoint endpoint = request.getEndpoint();
                if (Objects.isNull(endpoint)) {
                    return;
                }
                KeyValueMap map = new KeyValueMap();
                map.put("p", Production.COMMON.getName());
                map.put("mt", Common.Mt.rtbConversion.original());
                map.put("rtb", this.getRtb(target));
                map.put("bxmid", endpoint.getCountId());
                map.put("type", (Object)Optional.ofNullable(endpoint.getType()).orElse(0));
                map.put("uid", endpoint.getUid());
                map.put("time", (Object)System.currentTimeMillis());
                map.put("adid", (Object)endpoint.getTicketId());
                map.put("tagid", endpoint.getAppKey() + "-" + endpoint.getBusiness());
                map.put("createid", endpoint.getAssetsId());
                map.put("ip", endpoint.getIp());
                map.put("ua", UrlHelper.urlEncode(endpoint.getUserAgent()));
                map.put("refer", UrlHelper.urlEncode(request.getReferrer()));
                map.put("rtb_request_uri", UrlHelper.urlEncode(request.getRequestUrl()));
                map.put("rtb_event_type", request.getEventType());
                map.put("rtb_req_body", UrlHelper.urlEncode(request.getRequestBody()));
                map.put("rtb_res_body", UrlHelper.urlEncode(response.getBody()));
                map.put("rtb_res_msg", UrlHelper.urlEncode(response.getMsg()));
                this.fillDevice(target, request, map);
                String openLogRequestUri = map.createOpenLogRequestUri(RtbConversionAutoConfiguration.this.properties.getOpenLogRequestDomain(), false);
                openLogClient.asyncRequest(openLogRequestUri, (Consumer)new Consumer<Fallback>(){

                    @Override
                    public void accept(Fallback fallback) {
                        log.warn("OpenLog request fail: {}", (Object)fallback.getUrl());
                    }
                });
            }

            private String getRtb(RtbConversion target) {
                if (target.getType() == RtbConversion.Type.Kuaishou) {
                    return Common.RtbType.Kuaishou.getId();
                }
                if (target.getType() == RtbConversion.Type.Lagesi) {
                    return Common.RtbType.Lagesi.getId();
                }
                return target.getType().name();
            }

            private void fillDevice(RtbConversion target, RtbConversionRequest request, KeyValueMap map) {
                if (target.getType() == RtbConversion.Type.Kuaishou) {
                    String referrer = request.getReferrer();
                    if (StringUtils.isBlank((String)referrer)) {
                        return;
                    }
                    String url = UrlHelper.urlDecode(referrer);
                    String cbvalue = UrlHelper.getFirstValueOfParamName(url, "callback");
                    if (StringUtils.isBlank((String)cbvalue)) {
                        return;
                    }
                    KuaishouTrackerDto trackerDto = RtbConversionAutoConfiguration.this.kuaishouTrackerService.getTrackerDto(cbvalue);
                    if (Objects.isNull(trackerDto)) {
                        return;
                    }
                    if (StringUtils.isNotBlank((String)trackerDto.getImei2())) {
                        map.put("imei_md5", trackerDto.getImei2());
                    }
                    if (StringUtils.isNotBlank((String)trackerDto.getIdfa2())) {
                        map.put("idfa_md5", trackerDto.getIdfa2());
                    }
                    if (StringUtils.isNotBlank((String)trackerDto.getAndroidid2())) {
                        map.put("androidid_md5", trackerDto.getAndroidid2());
                    }
                    if (StringUtils.isNotBlank((String)trackerDto.getOaid())) {
                        map.put("oaid", trackerDto.getOaid());
                    }
                    if (StringUtils.isNotBlank((String)trackerDto.getOaid2())) {
                        map.put("oaid_md5", trackerDto.getOaid2());
                    }
                }
            }
        });
    }
}

