/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.impl;

import com.bxm.adscounter.facade.model.SspUserData;
import com.bxm.adscounter.integration.UserMappingIntegration;
import com.bxm.adscounter.service.SspUserService;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

@Service
public class SspUserServiceImpl
implements SspUserService {
    private static final Logger log = LoggerFactory.getLogger(SspUserServiceImpl.class);
    private static final int EXPIRE_TIME = 604800;
    private final Counter counter;
    private final UserMappingIntegration userMappingIntegration;

    public SspUserServiceImpl(@Qualifier(value="jedisCounter") Counter counter, UserMappingIntegration userMappingIntegration) {
        this.counter = counter;
        this.userMappingIntegration = userMappingIntegration;
    }

    @Override
    public void plusActivityJoin(String appId, String positionId, String uid) {
        String cuid = this.userMappingIntegration.getByCuid(appId, uid, Boolean.TRUE);
        if (StringUtils.isBlank((CharSequence)cuid)) {
            log.warn("cuid is empty, appId={},positionId={},uid={}", new Object[]{appId, positionId, uid});
            return;
        }
        this.counter.hincrementAndGet(SspUserServiceImpl.getActivityJoinKeyGenerator(appId), cuid, 604800);
        if (StringUtils.isNotBlank((CharSequence)positionId)) {
            this.counter.hincrementAndGet(SspUserServiceImpl.getActivityJoinPositionKeyGenerator(appId, positionId), cuid, 604800);
        }
    }

    @Override
    public List<SspUserData> getActivityJoinByAppId(String appId, String[] cuids, String date) {
        if (ArrayUtils.isEmpty((Object[])cuids) || cuids.length > 999) {
            throw new IllegalArgumentException("cuids");
        }
        Object original = this.counter.getClientOriginal();
        if (!(original instanceof JedisPool)) {
            return Collections.emptyList();
        }
        JedisPool jedisPool = (JedisPool)original;
        try (Jedis jedis = jedisPool.getResource();){
            HashMap result = Maps.newHashMap();
            Pipeline pipelined = jedis.pipelined();
            for (String cuid : cuids) {
                KeyGenerator k = SspUserServiceImpl.getActivityJoinKeyGenerator(date, appId);
                result.put(cuid, pipelined.hget(k.generateKey(), cuid));
            }
            pipelined.syncAndReturnAll();
            if (MapUtils.isNotEmpty((Map)result)) {
                ArrayList rs = Lists.newArrayListWithCapacity((int)result.size());
                for (Map.Entry entry : result.entrySet()) {
                    String cuid;
                    cuid = (String)entry.getKey();
                    Response redisRes = (Response)entry.getValue();
                    long times = NumberUtils.toLong((String)((String)redisRes.get()));
                    rs.add(SspUserData.builder().cuid(cuid).isActivityJoin(Boolean.valueOf(times > 0L)).build());
                }
                ArrayList arrayList = rs;
                return arrayList;
            }
        }
        return null;
    }

    @Override
    public List<SspUserData> getActivityJoinByAppId(String appId, String positionId, String[] cuids, String date) {
        if (ArrayUtils.isEmpty((Object[])cuids) || cuids.length > 999) {
            throw new IllegalArgumentException("cuids");
        }
        Object original = this.counter.getClientOriginal();
        if (!(original instanceof JedisPool)) {
            return Collections.emptyList();
        }
        JedisPool jedisPool = (JedisPool)original;
        try (Jedis jedis = jedisPool.getResource();){
            HashMap result = Maps.newHashMap();
            Pipeline pipelined = jedis.pipelined();
            for (String cuid : cuids) {
                KeyGenerator k = SspUserServiceImpl.getActivityJoinPositionKeyGenerator(date, appId, positionId);
                result.put(cuid, pipelined.hget(k.generateKey(), cuid));
            }
            pipelined.syncAndReturnAll();
            if (MapUtils.isNotEmpty((Map)result)) {
                ArrayList rs = Lists.newArrayListWithCapacity((int)result.size());
                for (Map.Entry entry : result.entrySet()) {
                    String cuid;
                    cuid = (String)entry.getKey();
                    Response redisRes = (Response)entry.getValue();
                    long times = NumberUtils.toLong((String)((String)redisRes.get()));
                    rs.add(SspUserData.builder().cuid(cuid).isActivityJoin(Boolean.valueOf(times > 0L)).build());
                }
                ArrayList arrayList = rs;
                return arrayList;
            }
        }
        return null;
    }

    private static KeyGenerator getActivityJoinKeyGenerator(String appId) {
        return SspUserServiceImpl.getActivityJoinKeyGenerator(DateHelper.getDate(), appId);
    }

    private static KeyGenerator getActivityJoinKeyGenerator(String date, String appId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "COUNTER", "ACTIVITY_JOIN", "SSP", date, appId});
    }

    private static KeyGenerator getActivityJoinPositionKeyGenerator(String appId, String positionId) {
        return SspUserServiceImpl.getActivityJoinPositionKeyGenerator(DateHelper.getDate(), appId, positionId);
    }

    private static KeyGenerator getActivityJoinPositionKeyGenerator(String date, String appId, String positionId) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADX", "COUNTER", "ACTIVITY_JOIN", "SSP", "POSITION", date, appId, positionId});
    }
}

