/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.activity.join;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketCounterConstant;
import com.bxm.adscounter.service.SspUserService;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.ActivityJoinEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PopupClickJoinEventListener
implements EventListener<ActivityJoinEvent> {
    private static final Logger log = LoggerFactory.getLogger(PopupClickJoinEventListener.class);
    @Resource
    private RedisClient redisClient;
    @Resource
    private SspUserService sspUserService;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityJoinEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        if (null != endpoint.getSspAppId()) {
            this.sspUserService.plusActivityJoin(endpoint.getSspAppId(), endpoint.getSspPositionId(), endpoint.getUid());
        }
        if (2 == endpoint.getScene() && StringUtils.isNotBlank((CharSequence)endpoint.getPopupId())) {
            String business = endpoint.getBusiness();
            if (StringUtils.isBlank((CharSequence)business)) {
                return;
            }
            String positionId = endpoint.getAppKey() + business.replace("ad", "");
            this.redisClient.hincrBy(() -> KeyBuilder.build((Object[])new Object[]{"AD", "ACTIVITY", "POPUP", "CLICK", TicketCounterConstant.SceneType.getValue((int)endpoint.getScene()), positionId}), endpoint.getPopupId(), 1, 3);
        }
    }
}

