/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.activity.show;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketCounterConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.ActivityShowEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StayPopupUVShowEventListener
implements EventListener<ActivityShowEvent> {
    private static final Logger log = LoggerFactory.getLogger(StayPopupUVShowEventListener.class);
    @Resource
    private RedisClient redisClient;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityShowEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        if (2 == endpoint.getScene() && StringUtils.isNotBlank((CharSequence)endpoint.getPopupId())) {
            String business = endpoint.getBusiness();
            if (StringUtils.isBlank((CharSequence)business)) {
                return;
            }
            String positionId = endpoint.getAppKey() + business.replace("ad", "");
            this.redisClient.pfadd(() -> KeyBuilder.build((Object[])new Object[]{"AD", "ACTIVITY", "POPUP", "INDEXUV", TicketCounterConstant.SceneType.getValue((int)endpoint.getScene()), endpoint.getPopupId(), positionId}), endpoint.getUid(), 3);
        }
    }
}

