/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.activity.show;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.ActivityShowEvent;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.bxm.warcar.utils.UUIDHelper;
import com.google.common.collect.Maps;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.TmcMessageProduceRequest;
import com.taobao.api.response.TmcMessageProduceResponse;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class TaobaoReportingActivityShowEventListener
implements EventListener<ActivityShowEvent> {
    private static final Logger log = LoggerFactory.getLogger(TaobaoReportingActivityShowEventListener.class);
    private static final String TOPIC = "mmc_pos_AdCatUserBack";
    private static final String APP_KEY = "33350421";
    private static final String APP_SECRET = "ae908415819249956e6d2a17d5539c32";
    private final Counter counter;
    private final Updater updater;
    private final TaobaoClient taobaoClient;

    public TaobaoReportingActivityShowEventListener(Counter counter, Updater updater) {
        this.counter = counter;
        this.updater = updater;
        this.taobaoClient = new DefaultTaobaoClient("http://gw.api.taobao.com/router/rest", APP_KEY, APP_SECRET, "json", 1000, 2000);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(ActivityShowEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        String referrer = endpoint.getReferrer();
        if (StringUtils.isBlank((CharSequence)referrer)) {
            return;
        }
        String uid = endpoint.getUid();
        UriComponents build = UriComponentsBuilder.fromUriString((String)referrer).build();
        MultiValueMap params = build.getQueryParams();
        String storeId = (String)params.getFirst((Object)"storeId");
        String taskId = (String)params.getFirst((Object)"taskId");
        if (StringUtils.isBlank((CharSequence)storeId) || StringUtils.isBlank((CharSequence)taskId)) {
            return;
        }
        if (this.isDuplicateOnToday(uid)) {
            return;
        }
        this.report(uid, storeId, taskId);
        this.storeReferrer(uid, referrer);
    }

    private void report(String uid, String storeId, String taskId) {
        HashMap param = Maps.newHashMap();
        param.put("message_id", UUIDHelper.generate());
        param.put("message_type", "exposure");
        param.put("store_id", NumberUtils.toLong((String)storeId));
        param.put("uid", uid);
        param.put("task_id", taskId);
        param.put("timestamp", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        param.put("time", DateHelper.format((String)"yyyy-MM-dd"));
        String content = JsonHelper.convert((Object)param);
        TmcMessageProduceRequest request = new TmcMessageProduceRequest();
        request.setContent(content);
        request.setTopic(TOPIC);
        request.setTargetGroup("default");
        try {
            TmcMessageProduceResponse response = (TmcMessageProduceResponse)this.taobaoClient.execute((TaobaoRequest)request);
            if (Objects.isNull(response) || !Optional.ofNullable(response.getIsSuccess()).orElse(Boolean.FALSE).booleanValue()) {
                log.info("Taobao report is fail! {}", (Object)content);
            }
        }
        catch (ApiException e) {
            log.error("execute: ", (Throwable)e);
        }
    }

    private boolean isDuplicateOnToday(String uid) {
        KeyGenerator key = () -> KeyBuilder.build((Object[])new Object[]{"tmp", "tb", "rep", "show", DateHelper.getDate(), LocalTime.now().getHour()});
        long exp = DateHelper.getRemainSecondsOfToday() + (long)RandomUtils.nextInt((int)0, (int)600);
        return this.counter.hincrementAndGet(key, uid, TypeHelper.castToInt((Object)exp).intValue()) > 1L;
    }

    private void storeReferrer(String uid, String referrer) {
        this.updater.updateWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"tmp", "tb", "refer", uid}), (Object)referrer, 691200, 6);
    }
}

