/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.model.constant.TicketCounterConstant;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AdPopupClickEventListener
implements EventListener<TicketClickAsyncEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdPopupClickEventListener.class);
    @Resource
    private RedisClient redisClient;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        String business;
        GeneralEndpoint endpoint = event.getEndpoint();
        if (StringUtils.isNotBlank((CharSequence)endpoint.getPopupId()) && 2 != endpoint.getScene() && StringUtils.isNotBlank((CharSequence)(business = endpoint.getBusiness()))) {
            String positionId = endpoint.getAppKey() + business.replace("ad", "");
            this.redisClient.hincrBy(() -> KeyBuilder.build((Object[])new Object[]{"AD", "ACTIVITY", "POPUP", "CLICK", TicketCounterConstant.SceneType.getValue((int)endpoint.getScene()), positionId}), endpoint.getPopupId(), 1, 3);
        }
    }
}

