/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class FmTicketClickOfferEventListener
implements EventListener<TicketClickAsyncEvent> {
    @Autowired
    @Qualifier(value="jedisUpdaterForFM")
    private JedisUpdater jedisUpdaterForFM;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        if (event == null) {
            return;
        }
        Ticket ticket = event.getTicket();
        if (ticket != null && ticket.getOfferPrice() != null && event.getEndpoint() != null) {
            GeneralEndpoint endpoint = event.getEndpoint();
            Integer offerPrice = ticket.getOfferPrice();
            if (StringUtils.isBlank((CharSequence)endpoint.getUid())) {
                return;
            }
            this.jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getPrevCost().generateKey(), (Object)offerPrice, (int)TimeUnit.DAYS.toSeconds(3L));
            if (endpoint.getActivityId() != null) {
                this.jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getPrevCost((long)endpoint.getActivityId()).generateKey(), (Object)offerPrice, (int)TimeUnit.DAYS.toSeconds(3L));
            }
            if (StringUtils.isNotBlank((CharSequence)endpoint.getAssetsId())) {
                this.jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getPrevAssetIdCost((long)Long.valueOf(endpoint.getAssetsId())).generateKey(), (Object)offerPrice, (int)TimeUnit.DAYS.toSeconds(3L));
            }
        }
    }
}

