/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.autoconfigure.RedisClient;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MaterialReleaseClickEventListener
implements EventListener<TicketClickAsyncEvent> {
    private static final Logger log = LoggerFactory.getLogger(MaterialReleaseClickEventListener.class);
    @Resource
    private RedisClient redisClient;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        String business;
        GeneralEndpoint endpoint = event.getEndpoint();
        if (null != endpoint.getDirect() && 1 == endpoint.getDirect() && null != endpoint.getAssetsId() && StringUtils.isNotBlank((CharSequence)(business = endpoint.getBusiness()))) {
            String positionId = endpoint.getAppKey() + business.replace("ad", "");
            this.redisClient.hincrBy(() -> KeyBuilder.build((Object[])new Object[]{"AD", "DIRECT", "TICKET", "MATERIAL", "CLICK", positionId}), endpoint.getAssetsId(), 1, 3);
        }
    }
}

