/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.ticket.click;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.KeyBuilder;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TicketClickOfferEventListener
implements EventListener<TicketClickAsyncEvent> {
    private static final Logger log = LoggerFactory.getLogger(TicketClickOfferEventListener.class);
    @Resource
    @Qualifier(value="jedisUpdater")
    private Updater jedisUpdater;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketClickAsyncEvent event) {
        Ticket ticket = event.getTicket();
        GeneralEndpoint endpoint = event.getEndpoint();
        Integer offerPrice = ticket.getOfferPrice();
        this.jedisUpdater.updateWithSelector(() -> KeyBuilder.build((Object[])new Object[]{"AD", "OCPC", "OFFER_PRICE", endpoint.getOrderId()}), (Object)(null == offerPrice ? 0 : offerPrice), 86400, 0);
    }
}

