/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.ticket.show;

import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketShowEvent;
import com.bxm.adsprod.facade.ticket.TicketAssets;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FmGeneralTicketShowCountEventListener
implements EventListener<TicketShowEvent> {
    private static final Logger logger = LoggerFactory.getLogger(FmGeneralTicketShowCountEventListener.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisFetcherForFM")
    private JedisFetcher jedisFetcherForFM;
    @Autowired
    @Qualifier(value="jedisUpdaterForFM")
    private JedisUpdater jedisUpdaterForFM;
    @Autowired
    @Qualifier(value="jedisCounterForFM")
    private JedisCounter jedisCounterForFM;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketShowEvent event) {
        Date currentDate = new Date();
        GeneralEndpoint endpoint = event.getEndpoint();
        if (endpoint == null || StringUtils.isBlank((CharSequence)endpoint.getUid())) {
            return;
        }
        this.saveGloabelDataFromFm(endpoint, currentDate);
    }

    private void saveGloabelDataFromFm(GeneralEndpoint endpoint, Date currentDate) {
        Iterator iterator;
        List assetsList;
        this.jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getPrevShowDate().generateKey(), (Object)currentDate, (int)TimeUnit.DAYS.toSeconds(3L));
        if (endpoint.getActivityId() != null) {
            this.jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getPrevActivityShowDate((long)endpoint.getActivityId()).generateKey(), (Object)currentDate, (int)TimeUnit.DAYS.toSeconds(3L));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getAssetsId()) && !CollectionUtils.isEmpty((Collection)(assetsList = this.fetcher.hfetchList(TicketKeyGenerator.getTicketAssets(), String.valueOf(endpoint.getTicketId()), null, TicketAssets.class))) && (iterator = assetsList.iterator()).hasNext()) {
            TicketAssets ticketAssets = (TicketAssets)iterator.next();
            if (StringUtils.equalsIgnoreCase((CharSequence)endpoint.getAssetsId(), (CharSequence)ticketAssets.getId().toString())) {
                this.jedisUpdaterForFM.hupdate(TicketKeyGenerator.TicketFm.getLaterUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getRecordAssetId().generateKey(), (Object)(ticketAssets.getId() + "-" + ticketAssets.getIsShieldPopup()), (int)TimeUnit.DAYS.toSeconds(3L));
            }
        }
        String currentDay = DateHelper.format((Date)currentDate, (String)"yyyy-MM-dd");
        long userActivityCount = 0L;
        long userTicketCount = 0L;
        long userAssetIdCount = 0L;
        List<Date> prev2Day = this.getPrev2Day(currentDay);
        ArrayList<String> removeFields = new ArrayList<String>(6);
        for (Date day : prev2Day) {
            Long currentDayTicketCount;
            Long activityCount = null;
            if (endpoint.getActivityId() != null && (activityCount = (Long)this.jedisFetcherForFM.hfetch(TicketKeyGenerator.TicketFm.getSeqLatelyUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getSeqCount((Date)day, (long)endpoint.getActivityId()).generateKey(), Long.class)) != null) {
                removeFields.add(TicketKeyGenerator.TicketFm.getSeqCount((Date)day, (long)endpoint.getActivityId()).generateKey());
            }
            if ((currentDayTicketCount = (Long)this.jedisFetcherForFM.hfetch(TicketKeyGenerator.TicketFm.getSeqLatelyUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getSeqCountNotTicketId((Date)day).generateKey(), Long.class)) != null) {
                removeFields.add(TicketKeyGenerator.TicketFm.getSeqCountNotTicketId((Date)day).generateKey());
            }
            Long assetIdCount = null;
            if (StringUtils.isNotBlank((CharSequence)endpoint.getAssetsId()) && (assetIdCount = (Long)this.jedisFetcherForFM.hfetch(TicketKeyGenerator.TicketFm.getSeqLatelyUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getSeqAssetIdCount((Date)day, (long)Long.valueOf(endpoint.getAssetsId())).generateKey(), Long.class)) != null) {
                removeFields.add(TicketKeyGenerator.TicketFm.getSeqAssetIdCount((Date)day, (long)Long.valueOf(endpoint.getAssetsId())).generateKey());
            }
            if (activityCount != null) {
                userActivityCount += activityCount.longValue();
            }
            if (currentDayTicketCount != null) {
                userTicketCount += currentDayTicketCount.longValue();
            }
            if (assetIdCount == null) continue;
            userAssetIdCount += assetIdCount.longValue();
        }
        if (!CollectionUtils.isEmpty(removeFields)) {
            this.jedisUpdaterForFM.hremove(TicketKeyGenerator.TicketFm.getSeqLatelyUser((String)endpoint.getUid()), removeFields.toArray(new String[0]));
        }
        this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getSeqLatelyUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getSeqCountNotTicketId((Date)currentDate).generateKey(), userTicketCount + 1L, (int)TimeUnit.DAYS.toSeconds(3L));
        if (endpoint.getActivityId() != null) {
            this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getSeqLatelyUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getSeqCount((Date)currentDate, (long)endpoint.getActivityId()).generateKey(), userActivityCount + 1L, (int)TimeUnit.DAYS.toSeconds(3L));
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getAssetsId())) {
            this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getSeqLatelyUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getSeqAssetIdCount((Date)currentDate, (long)Long.valueOf(endpoint.getAssetsId())).generateKey(), userAssetIdCount + 1L, (int)TimeUnit.DAYS.toSeconds(3L));
        }
        this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getUserEveryTicketCount((String)endpoint.getUid()), String.valueOf(endpoint.getTicketId()), 1L, (int)DateHelper.getRemainSecondsOfToday());
    }

    private List<Date> getPrev2Day(String currentDay) {
        String preDate = null;
        String preDate2 = null;
        try {
            preDate = DateHelper.getPreDate((String)currentDay);
            preDate2 = DateHelper.getPreDate((String)preDate);
        }
        catch (ParseException e2) {
            logger.error("get prev3 day error ", (Throwable)e2);
        }
        return Stream.of(preDate, preDate2).filter(e -> e != null).map(e -> DateHelper.parse((String)e, (String)"yyyy-MM-dd")).collect(Collectors.toList());
    }
}

