/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.listeners.general.ticket.show;

import com.bxm.adscounter.facade.model.fm.FmPrevTicketCountDto;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketShowEvent;
import com.bxm.adsprod.facade.tag.Tag;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.impls.redis.JedisCounter;
import com.bxm.warcar.cache.impls.redis.JedisFetcher;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.TargetFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FmTicketShowCountEventListener
implements EventListener<TicketShowEvent> {
    private static final Logger logger = LoggerFactory.getLogger(FmTicketShowCountEventListener.class);
    public static final String CACHE_DEFAULT_VALUE = "1";
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisFetcherForFM")
    private JedisFetcher jedisFetcherForFM;
    @Autowired
    @Qualifier(value="jedisUpdaterForFM")
    private JedisUpdater jedisUpdaterForFM;
    @Autowired
    @Qualifier(value="jedisCounterForFM")
    private JedisCounter jedisCounterForFM;
    @Autowired
    @Qualifier(value="fmCacheFetcher")
    private com.bxm.warcar.xcache.Fetcher xfetcher;

    @Subscribe
    @AllowConcurrentEvents
    public void consume(TicketShowEvent event) {
        GeneralEndpoint endpoint = event.getEndpoint();
        if (endpoint == null || StringUtils.isBlank((CharSequence)endpoint.getUid())) {
            return;
        }
        this.saveTicketCountFromFm(endpoint, event.getTicket());
        this.saveUserActualDataFromFm(endpoint);
    }

    private void saveUserActualDataFromFm(GeneralEndpoint endpoint) {
        String spm = endpoint.getSpm();
        if (StringUtils.isNotBlank((CharSequence)spm) && endpoint.getActivityId() != null) {
            this.jedisCounterForFM.hincrementAndGet(TicketKeyGenerator.TicketFm.getCurrentUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getCurrentActivity((long)endpoint.getActivityId()).generateKey());
        }
        this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getTicketCountCurrentDay().generateKey(), 1L, (int)DateHelper.getRemainSecondsOfToday());
        if (endpoint.getTicketId() != null) {
            this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getTicketCountRepeat((long)endpoint.getTicketId()).generateKey(), 1L, (int)DateHelper.getRemainSecondsOfToday());
        }
        if (endpoint.getActivityId() != null) {
            this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getActivityCount((long)endpoint.getActivityId()).generateKey(), 1L, (int)DateHelper.getRemainSecondsOfToday());
        }
        if (StringUtils.isNotBlank((CharSequence)endpoint.getAssetsId())) {
            this.jedisCounterForFM.hincrementByAndGet(TicketKeyGenerator.TicketFm.getCurrentUser((String)endpoint.getUid()), TicketKeyGenerator.TicketFm.getSeqAssetIdViewCount((long)Long.valueOf(endpoint.getAssetsId())).generateKey(), 1L, (int)DateHelper.getRemainSecondsOfToday());
        }
    }

    private void saveTicketCountFromFm(GeneralEndpoint endpoint, Ticket ticket) {
        Long ticketId = endpoint.getTicketId();
        Long activityId = endpoint.getActivityId();
        if (ticketId == null && activityId == null) {
            return;
        }
        String tags = null;
        if (ticket == null && ticketId != null) {
            ticket = (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), String.valueOf(ticketId), null, Ticket.class);
        }
        List tagCodes = null;
        if (ticket != null && !CollectionUtils.isEmpty((Collection)ticket.getTags())) {
            Set tagsSet = (Set)this.xfetcher.fetch(new TargetFactory().keyGenerator(TicketKeyGenerator.getAttributeTag()).cls(Set.class).build());
            tagCodes = ticket.getTags().stream().map(Tag::getCode).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)tagsSet)) {
                tagCodes.removeAll(tagsSet);
            }
        }
        if (!CollectionUtils.isEmpty(tagCodes)) {
            for (String tagCode : tagCodes) {
                tags = (String)this.jedisFetcherForFM.hfetch(TicketKeyGenerator.Tags.getTags(), tagCode, String.class);
                if (!StringUtils.isNotBlank((CharSequence)tags)) continue;
                break;
            }
        }
        FmPrevTicketCountDto ticketCountDto = new FmPrevTicketCountDto();
        ticketCountDto.setActivityId(Long.valueOf(activityId == null ? -1L : activityId));
        ticketCountDto.setTicketId(Long.valueOf(ticketId == null ? -1L : ticketId));
        ticketCountDto.setTags(tags == null ? "" : tags);
        this.jedisUpdaterForFM.update(FmTicketShowCountEventListener.getPrevTicketInfoByUid(endpoint.getUid()), (Object)ticketCountDto, (int)DateHelper.getRemainSecondsOfToday());
    }

    public static KeyGenerator getPrevTicketInfoByUid(String uid) {
        return () -> KeyBuilder.build((Object[])new Object[]{"ADA", "RECORD", "USERS", "DATE", DateHelper.getDate(), uid});
    }
}

