/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.feedback;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedbackFactory;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEvent;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConversionFeedbackDispatcher {
    private static final Logger log = LoggerFactory.getLogger(ConversionFeedbackDispatcher.class);
    private final ConversionFeedbackFactory conversionFeedbackFactory;

    public ConversionFeedbackDispatcher(ConversionFeedbackFactory conversionFeedbackFactory) {
        this.conversionFeedbackFactory = conversionFeedbackFactory;
    }

    public void dispatch(OpenLogEvent event) {
        KeyValueMap feedback = event.getLog();
        String bxmmedia = (String)feedback.getFirst((Object)"bxmmedia");
        String bxmadvertiser = (String)feedback.getFirst((Object)"bxmadvertiser");
        if (StringUtils.isBlank((CharSequence)bxmmedia)) {
            log.warn("[ConversionFeedbackDispatcher] Missing param 'bxmmedia'.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)bxmadvertiser)) {
            log.warn("[ConversionFeedbackDispatcher] Missing param 'bxmadvertiser'.");
            return;
        }
        RtbMedia rtbMedia = RtbMedia.getByType((String)bxmmedia);
        if (Objects.isNull(rtbMedia)) {
            log.warn("[ConversionFeedbackDispatcher] Illegal bxmmedia [{}]", (Object)bxmmedia);
            return;
        }
        RtbAdvertiser rtbAdvertiser = RtbAdvertiser.getByType((String)bxmadvertiser);
        if (Objects.isNull(rtbAdvertiser)) {
            log.warn("[ConversionFeedbackDispatcher] Illegal bxmadvertiser [{}]", (Object)bxmadvertiser);
            return;
        }
        ConversionFeedback conversionFeedback = (ConversionFeedback)this.conversionFeedbackFactory.get(rtbMedia);
        if (Objects.isNull(conversionFeedback)) {
            log.warn("[ConversionFeedbackDispatcher] Cannot found target ConversionFeedback, rtbMedia: [{}]", (Object)rtbMedia);
            return;
        }
        String clickId = (String)feedback.getFirst((Object)"click_id");
        if (StringUtils.isBlank((CharSequence)clickId)) {
            log.warn("[ConversionFeedbackDispatcher] Missing param 'click_id'.");
            return;
        }
        String convDef = (String)feedback.getFirst((Object)"conv_def");
        if (StringUtils.isBlank((CharSequence)convDef)) {
            log.warn("[ConversionFeedbackDispatcher] Missing param 'conv_def'.");
            return;
        }
        String transformType = (String)feedback.getFirst((Object)rtbAdvertiser.getTransferType());
        String targetType = this.getTargetType(transformType, convDef);
        if (StringUtils.isBlank((CharSequence)targetType)) {
            log.warn("[ConversionFeedbackDispatcher] Cannot found target type [{}] . convDef: {}", (Object)transformType, (Object)convDef);
            return;
        }
        if (this.doIntercept(feedback)) {
            return;
        }
        conversionFeedback.feedback(feedback, clickId, targetType);
    }

    private boolean doIntercept(KeyValueMap m) {
        double random;
        double ratio;
        String convRatio = (String)m.getFirst((Object)"conv_ratio");
        double maxRate = 100.0;
        if (StringUtils.isNotBlank((CharSequence)convRatio) && (ratio = Double.parseDouble(convRatio)) < maxRate && (random = RandomUtils.nextDouble((double)0.0, (double)maxRate)) > ratio) {
            log.info("[ReporterDispatcher] Conversion feedback is intercepted by convRatio[{}]", (Object)convRatio);
            return true;
        }
        return false;
    }

    String getTargetType(String transformType, String convDef) {
        String[] strings;
        HashMap<String, String> conv = new HashMap<String, String>();
        for (String string : strings = StringUtils.split((String)convDef, (String)",")) {
            String[] arr = StringUtils.split((String)string, (String)"-");
            if (arr.length < 2) continue;
            String src = arr[0];
            String dest = arr[1];
            conv.put(src, dest);
        }
        return (String)conv.get(transformType);
    }
}

