/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.utils.HttpClientUtils;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class IqiyiConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(IqiyiConversionFeedback.class);
    private final HttpClient httpClient = HttpClientUtils.createHttpClient((int)50, (int)100, (int)1000, (int)500, (int)1000);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        String feedbackUrl = UrlHelper.urlDecode(clickId);
        if (StringUtils.isBlank((String)feedbackUrl)) {
            return;
        }
        String url = UriComponentsBuilder.fromUriString((String)feedbackUrl).replaceQueryParam("event_type", new Object[]{targetType}).build().toString();
        HttpGet get = new HttpGet(url);
        try {
            this.httpClient.execute((HttpUriRequest)get);
            log.info("[iqiyi] ocpx conversion success - url: {} ", (Object)url);
        }
        catch (IOException e) {
            log.error("execute: ", (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.IQIYI;
    }
}

