/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.feedback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.vivo.VivoRtbIntegration;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adsprod.facade.ticket.rtb.PositionRtb;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.StringHelper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class VivoConversionFeedback
implements ConversionFeedback {
    private static final Logger log = LoggerFactory.getLogger(VivoConversionFeedback.class);
    private final VivoRtbIntegration vivoRtbIntegration;

    public VivoConversionFeedback(VivoRtbIntegration vivoRtbIntegration) {
        this.vivoRtbIntegration = vivoRtbIntegration;
    }

    @Override
    public void feedback(KeyValueMap feedbackLog, String clickId, String targetType) {
        try {
            String pkgname;
            String srcid;
            JSONObject json = new JSONObject();
            String extParams = (String)feedbackLog.getFirst((Object)"ext_params");
            if (StringUtils.isNotBlank((String)extParams)) {
                try {
                    byte[] base64 = Base64.decodeBase64((String)extParams);
                    json = JSONObject.parseObject((String)StringHelper.convert((byte[])base64));
                }
                catch (Exception e) {
                    log.warn("{} - {}", (Object)extParams, (Object)e.getMessage());
                }
            }
            if (StringUtils.isBlank((String)(srcid = json.getString("srcid")))) {
                srcid = "ds-202208191223";
            }
            if (StringUtils.isBlank((String)(pkgname = json.getString("pkgname")))) {
                pkgname = "com.sankuai.meituan";
            }
            String advertiserid = json.getString("advertiserid");
            String creativeid = json.getString("creativeid");
            PositionRtb config = new PositionRtb();
            config.setToken("29a5682c520e1d344cf530cdf6dd4f896a0742c3fc5e55b92d313eaf26167ea9");
            config.setSourceId(srcid);
            config.setCustomerId(advertiserid);
            feedbackLog.putIfNotBlank("advertiserid", advertiserid);
            feedbackLog.putIfNotBlank("creativeid", creativeid);
            feedbackLog.putIfNotBlank("pkgname", pkgname);
            FeedbackRequest request = FeedbackRequest.builder().config(config).keyValueMap(feedbackLog).clickId(clickId).eventType(targetType).referrer(json.getString("pageUrl")).build();
            this.vivoRtbIntegration.doFeedback(request, 2);
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }

    @Override
    public String createExtParams(KeyValueMap clickLog) {
        HashMap ext = Maps.newHashMap();
        ext.put("advertiserid", (String)clickLog.getFirst((Object)"advertiserid"));
        ext.put("creativeid", (String)clickLog.getFirst((Object)"creativeid"));
        ext.put("pkgname", (String)clickLog.getFirst((Object)"pkgname"));
        ext.put("srcid", (String)clickLog.getFirst((Object)"srcid"));
        ext.put("pageUrl", (String)clickLog.getFirst((Object)"pageUrl"));
        return Base64.encodeBase64URLSafeString((byte[])JsonHelper.convert2bytes((Object)ext));
    }

    @Override
    public RtbMedia rtbMedia() {
        return RtbMedia.VIVO;
    }
}

