/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.rtb.common.RtbIntegrationException;
import com.bxm.adscounter.rtb.common.feedback.FeedbackRequest;
import com.bxm.adscounter.rtb.common.impl.juliang.OceanEngineRtbIntegration;
import com.bxm.adscounter.service.openlog.common.event.DhhConversionEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DhhConversionEventListener
implements EventListener<DhhConversionEvent> {
    private static final Logger log = LoggerFactory.getLogger(DhhConversionEventListener.class);
    private final OceanEngineRtbIntegration oceanEngineRtbIntegration;

    public DhhConversionEventListener(OceanEngineRtbIntegration oceanEngineRtbIntegration) {
        this.oceanEngineRtbIntegration = oceanEngineRtbIntegration;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(DhhConversionEvent event) {
        String[] strings;
        KeyValueMap m = event.getLog();
        String clickId = (String)m.getFirst((Object)"click_id");
        String convDef = (String)m.getFirst((Object)"conv_def");
        String transformType = (String)m.getFirst((Object)"transformType");
        if (StringUtils.isBlank((CharSequence)convDef)) {
            log.warn("{} Not value of 'conv_def'", (Object)clickId);
            return;
        }
        HashMap<String, String> conv = new HashMap<String, String>();
        for (String string : strings = StringUtils.split((String)convDef, (String)",")) {
            String[] arr = StringUtils.split((String)string, (String)"-");
            if (arr.length < 2) continue;
            String src = arr[0];
            String dest = arr[1];
            conv.put(src, dest);
        }
        if (!conv.containsKey(transformType)) {
            return;
        }
        String targetType = (String)conv.get(transformType);
        try {
            this.oceanEngineRtbIntegration.doFeedback(FeedbackRequest.builder().keyValueMap(m).eventType(targetType).clickId(clickId).build());
        }
        catch (RtbIntegrationException rtbIntegrationException) {
            // empty catch block
        }
    }
}

