/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.integration.taobao.TaobaoIntegration;
import com.bxm.adscounter.integration.taobao.TaobaoProperties;
import com.bxm.adscounter.integration.taobao.TaobaoRequest;
import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.common.event.OceanengineClickMonitorEvent;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OceanengineClickEventListener
implements EventListener<OceanengineClickMonitorEvent> {
    private final Properties properties;
    private final TaobaoIntegration taobaoIntegration;
    private final TaobaoProperties taobaoProperties;

    public OceanengineClickEventListener(Properties properties, TaobaoIntegration taobaoIntegration, TaobaoProperties taobaoProperties) {
        this.properties = properties;
        this.taobaoIntegration = taobaoIntegration;
        this.taobaoProperties = taobaoProperties;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(OceanengineClickMonitorEvent event) {
        KeyValueMap m = event.getLog();
        String imei = (String)m.getFirst((Object)"imei");
        String oaid = (String)m.getFirst((Object)"oaid");
        String oaidMd5 = (String)m.getFirst((Object)"oaid_md5");
        String androidid = (String)m.getFirst((Object)"androidid");
        String idfa = (String)m.getFirst((Object)"idfa");
        String clickId = (String)m.getFirst((Object)"click_id");
        String app = (String)m.getFirst((Object)"app");
        String taskId = (String)m.getFirst((Object)"taskId");
        String channel = (String)m.getFirst((Object)"channel");
        String advertisingSpaceId = (String)m.getFirst((Object)"advertisingSpaceId");
        String adid = (String)m.getFirst((Object)"adid");
        String cid = (String)m.getFirst((Object)"cid");
        String adAgent = (String)m.getFirst((Object)"adAgent");
        String convDef = (String)m.getFirst((Object)"conv_def");
        TaobaoRequest request = new TaobaoRequest();
        request.setReportUrl(this.taobaoProperties.getReportClickUrl()).setTaskId(taskId).setApp(app).setChannel(channel).setAdid(adid).setCid(cid).setAdAgent(adAgent).setAdvertisingSpaceId(advertisingSpaceId).setImei(imei).setOaid(oaid).setOaidMd5(oaidMd5).setIdfa(idfa).setCallbackUrl(UrlHelper.urlEncode(this.getFeedbackUrl(clickId, convDef))).setTimestamp(TypeHelper.castToString((Object)System.currentTimeMillis()));
        this.taobaoIntegration.report(request);
    }

    private String getFeedbackUrl(String clickId, String convDef) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.COMMON);
        map.setMt(Common.Mt.DhhConversion.original());
        map.putIfNotBlank("click_id", clickId);
        map.putIfNotBlank("conv_def", convDef);
        return map.createOpenLogRequestUri(this.properties.getOpenLogRequestOutDomain());
    }
}

