/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.listener;

import com.bxm.adscounter.service.openlog.common.event.RtbConversionEvent;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.logging.extension.CustomLoggingWriter;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RtbConversionStorageEventListener
implements EventListener<RtbConversionEvent> {
    private static final Logger log = LoggerFactory.getLogger(RtbConversionStorageEventListener.class);
    private final CustomLoggingWriter writer;

    public RtbConversionStorageEventListener(@Qualifier(value="customLoggingWriterForRtbFeedback") CustomLoggingWriter writer) {
        this.writer = writer;
    }

    @Subscribe
    public void consume(RtbConversionEvent event) {
        KeyValueMap keyValueMap = event.getLog();
        HashMap data = Maps.newHashMap();
        keyValueMap.forEach((key, value) -> {
            String split = ",";
            StringBuilder s = new StringBuilder();
            if (CollectionUtils.isNotEmpty((Collection)value)) {
                value.forEach(e -> s.append((String)e).append(split));
            }
            data.put(key, StringUtils.removeEnd((String)s.toString(), (String)split));
        });
        this.writer.write((Map)data);
    }
}

