/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.report;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.model.RtbMedia;
import com.bxm.adscounter.service.autoconfigure.Properties;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedback;
import com.bxm.adscounter.service.openlog.common.feedback.ConversionFeedbackFactory;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.adscounter.service.openlog.common.report.ReporterFactory;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.openlog.sdk.Production;
import com.bxm.openlog.sdk.consts.Common;
import com.bxm.openlog.sdk.listener.eventbus.OpenLogEvent;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ReporterDispatcher {
    private static final Logger log = LoggerFactory.getLogger(ReporterDispatcher.class);
    private final ConversionFeedbackFactory conversionFeedbackFactory;
    private final ReporterFactory reporterFactory;
    private final Properties properties;

    public ReporterDispatcher(ConversionFeedbackFactory conversionFeedbackFactory, ReporterFactory reporterFactory, Properties properties) {
        this.conversionFeedbackFactory = conversionFeedbackFactory;
        this.reporterFactory = reporterFactory;
        this.properties = properties;
    }

    public void dispatch(OpenLogEvent event) {
        KeyValueMap clickTrackerLog = event.getLog();
        String bxmmedia = (String)clickTrackerLog.getFirst((Object)"bxmmedia");
        String bxmadvertiser = (String)clickTrackerLog.getFirst((Object)"bxmadvertiser");
        if (StringUtils.isBlank((CharSequence)bxmmedia)) {
            log.warn("[ReporterDispatcher] Missing param '{}'.", (Object)"bxmmedia");
            return;
        }
        if (StringUtils.isBlank((CharSequence)bxmadvertiser)) {
            log.warn("[ReporterDispatcher] Missing param '{}'.", (Object)"bxmadvertiser");
            return;
        }
        RtbMedia rtbMedia = RtbMedia.getByType((String)bxmmedia);
        RtbAdvertiser rtbAdvertiser = RtbAdvertiser.getByType((String)bxmadvertiser);
        if (Objects.isNull(rtbMedia)) {
            log.warn("[ReporterDispatcher] Illegal rtbMedia [{}]", (Object)bxmmedia);
            return;
        }
        if (Objects.isNull(rtbAdvertiser)) {
            log.warn("[ReporterDispatcher] Illegal rtbAdvertiser [{}]", (Object)bxmadvertiser);
            return;
        }
        ConversionFeedback rtbInstance = (ConversionFeedback)this.conversionFeedbackFactory.get(rtbMedia);
        if (Objects.isNull(rtbInstance)) {
            return;
        }
        rtbInstance.update(clickTrackerLog);
        String extParams = rtbInstance.createExtParams(clickTrackerLog);
        Reporter reporter = (Reporter)this.reporterFactory.get(rtbAdvertiser);
        if (Objects.isNull(reporter)) {
            log.warn("[ReporterDispatcher] Cannot found target reporter, rtbAdvertiser: {}", (Object)rtbAdvertiser);
            return;
        }
        String feedbackUrl = this.createBxmFeedbackUrl(clickTrackerLog, extParams, rtbMedia);
        reporter.report(clickTrackerLog, feedbackUrl);
    }

    public String createBxmFeedbackUrl(KeyValueMap clickTrackerLog, String extParams, RtbMedia rtbMedia) {
        KeyValueMap map = new KeyValueMap();
        map.setProduction(Production.COMMON);
        map.setMt(Common.Mt.oCpxFeedbackForCommon.original());
        map.putIfNotBlank("bxmmedia", (String)clickTrackerLog.getFirst((Object)"bxmmedia"));
        map.putIfNotBlank("bxmadvertiser", (String)clickTrackerLog.getFirst((Object)"bxmadvertiser"));
        map.putIfNotBlank("bxmextra", (String)clickTrackerLog.getFirst((Object)"bxmextra"));
        String clickId = (String)clickTrackerLog.getFirst((Object)"click_id");
        if (RtbMedia.GUANGDIANTONG.equals((Object)rtbMedia) && StringUtils.isNotBlank((CharSequence)clickId)) {
            clickId = UrlHelper.urlEncode(Base64.encodeBase64String((byte[])clickId.getBytes()));
        }
        if (RtbMedia.XIAOMI.equals((Object)rtbMedia)) {
            String imei = (String)clickTrackerLog.getFirst((Object)"imei");
            String oaid = (String)clickTrackerLog.getFirst((Object)"oaid");
            map.putIfNotBlank("x_imei", imei);
            map.putIfNotBlank("x_oaid", oaid);
        }
        map.putIfNotBlank("click_id", clickId);
        map.putIfNotBlank("conv_def", (String)clickTrackerLog.getFirst((Object)"conv_def"));
        map.putIfNotBlank("conv_ratio", (String)clickTrackerLog.getFirst((Object)"conv_ratio"));
        map.putIfNotBlank("ext_params", extParams);
        return map.createOpenLogRequestUri(this.properties.getOpenLogRequestOutDomain());
    }
}

