/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.common.report.impl;

import com.bxm.adscounter.model.RtbAdvertiser;
import com.bxm.adscounter.service.openlog.common.report.Reporter;
import com.bxm.adscounter.service.utils.UrlHelper;
import com.bxm.openlog.sdk.KeyValueMap;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class ElemeReporter
implements Reporter {
    private static final Logger log = LoggerFactory.getLogger(ElemeReporter.class);
    private final HttpClient httpClient;
    private static final String URL = "https://alsc-ug-monitor-callback.alibaba.com/streamMonitor/click";
    private static final String DEFAULT_SALT = "3f557aac72e247de7e6c47027b6fb7a7";

    public ElemeReporter() {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(2000).setConnectTimeout(1000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(KeyValueMap clickLog, String bxmFeedbackUrl) {
        boolean isIos = StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa"))) || StringUtils.isNotBlank((String)((String)clickLog.getFirst((Object)"idfa_md5")));
        String salt = (String)clickLog.getFirst((Object)"salt");
        String task_id = (String)clickLog.getFirst((Object)"task_id");
        String propagation_site = (String)clickLog.getFirst((Object)"propagation_site");
        String task_type = (String)clickLog.getFirst((Object)"task_type");
        if (StringUtils.isBlank((String)salt)) {
            salt = DEFAULT_SALT;
        }
        if (StringUtils.isBlank((String)task_id)) {
            log.warn("Eleme report cannot found 'task_id' from click url!");
            return;
        }
        if (StringUtils.isBlank((String)propagation_site)) {
            log.warn("Eleme report cannot found 'propagation_site' from click url!");
            return;
        }
        if (StringUtils.isBlank((String)task_type)) {
            log.warn("Eleme report cannot found 'task_type' from click url!");
            return;
        }
        String requestId = RandomStringUtils.randomAlphanumeric((int)8);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)URL).replaceQueryParam("request_id", new Object[]{requestId}).replaceQueryParam("imei", new Object[]{this.getDefault(clickLog.getFirst((Object)"imei"))}).replaceQueryParam("imei_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"imei"))}).replaceQueryParam("oaid", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid"))}).replaceQueryParam("oaid_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"oaid_md5"))}).replaceQueryParam("idfa", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa"))}).replaceQueryParam("idfa_md5", new Object[]{this.getDefault(clickLog.getFirst((Object)"idfa_md5"))}).replaceQueryParam("os", new Object[]{isIos ? 1 : 0}).replaceQueryParam("bxmId", new Object[]{requestId}).replaceQueryParam("mts", new Object[]{System.currentTimeMillis()}).replaceQueryParam("medium_source", new Object[]{-1}).replaceQueryParam("delivery_type", new Object[]{10}).replaceQueryParam("ascribe_type", new Object[]{3}).replaceQueryParam("demander_type", new Object[]{5}).replaceQueryParam("biz_type", new Object[]{2}).replaceQueryParam("task_id", new Object[]{task_id}).replaceQueryParam("propagator_id", new Object[]{"86457915D5205511D4C614FB283B347E"}).replaceQueryParam("propagation_site", new Object[]{propagation_site}).replaceQueryParam("task_type", new Object[]{task_type}).replaceQueryParam("callback_url", new Object[]{UrlHelper.urlEncode(bxmFeedbackUrl)});
        String signature = this.getSignature(uriComponentsBuilder, salt);
        String reqUrl = uriComponentsBuilder.replaceQueryParam("signature", new Object[]{signature}).build().toString();
        HttpGet get = new HttpGet(reqUrl);
        try {
            if (log.isInfoEnabled()) {
                log.info("{} - eleme reporting: {}", (Object)requestId, (Object)reqUrl);
            }
            HttpResponse res = this.httpClient.execute((HttpUriRequest)get);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            if (log.isInfoEnabled()) {
                log.info("{} - eleme response: {}", (Object)requestId, (Object)body);
            }
        }
        catch (IOException e) {
            log.error("{} - eleme report occur exception: {}", (Object)requestId, (Object)e.getMessage());
        }
        finally {
            get.releaseConnection();
        }
    }

    private String getSignature(UriComponentsBuilder uriComponentsBuilder, String salt) {
        return DigestUtils.md5Hex((String)(uriComponentsBuilder.build().toString() + salt));
    }

    @Override
    public RtbAdvertiser rtbAdvertiser() {
        return RtbAdvertiser.Eleme;
    }

    public static void main(String[] args) {
        String a = "https://alsc-ug-monitor-callback.alibaba.com/streamMonitor/click?request_id=LYKiAhFb&imei=&imei_md5=&oaid=3abcfd1e51b77748&oaid_md5=&idfa=&idfa_md5=&os=0&bxmId=LYKiAhFb&mts=1668588594314&medium_source=-1&delivery_type=10&ascribe_type=3&demander_type=5&biz_type=2&task_id=A6634CF433133C0D&propagator_id=86457915D5205511D4C614FB283B347E&propagation_site=35A5F32E17F33865&task_type=3A1&callback_url=https%3A%2F%2Fopenlog.hzbxm.com%2Fcommon%2Fs.gif%3Fp%3Dcommon%26mt%3D21%26bxmmedia%3Dxiaomi%26bxmadvertiser%3Deleme%26x_oaid%3D3abcfd1e51b77748%26click_id%3DFtAPFpKCBRgkNzQ1Yzg0OTUtYzFhMS00ZjQ1LThhYmMtNjE2Y2IyYjQxZGY5GAAVAhggMTExMTExMTExMTExMTExMTExMTExMTExMTExMTExMTEYIDIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyGBAzYWJjZmQxZTUxYjc3NzQ4AA%253D%253D%26conv_def%3D6-APP_RE_ACTIVE%252C4-APP_RETENTION%26conv_ratio%3D100.0%26ext_params%3DeyJ0ZXN0IjoiMSIsIm9haWQiOiIzYWJjZmQxZTUxYjc3NzQ4In0&smart_debug=1";
        System.out.println(DigestUtils.md5Hex((String)(a + DEFAULT_SALT)));
    }
}

