/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.rtb.common.utils.InadsExtValueUtils;
import com.bxm.adscounter.service.events.TicketClickAsyncEvent;
import com.bxm.adscounter.service.openlog.inads.event.AdClickEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.SyncEventPark;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdClickEventListener
implements EventListener<AdClickEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdClickEventListener.class);
    private final Fetcher fetcher;
    private final AsyncEventPark asyncEventPark;

    public AdClickEventListener(Fetcher fetcher, AsyncEventPark asyncEventPark, SyncEventPark syncEventPark) {
        this.fetcher = fetcher;
        this.asyncEventPark = asyncEventPark;
    }

    @Subscribe
    public void consume(AdClickEvent event) {
        KeyValueMap map = event.getLog();
        String adid = (String)map.getFirst((Object)"adid");
        String bxmId = (String)map.getFirst((Object)"bxmid");
        Ticket ticket = this.get(adid);
        if (Objects.isNull(ticket)) {
            log.warn("Not found: {}", (Object)adid);
            return;
        }
        ClickRequest req = new ClickRequest();
        req.setUid((String)map.getFirst((Object)"uid"));
        req.setTicketId(TypeHelper.castToBigInteger((Object)adid));
        req.setPosition((String)map.getFirst((Object)"tagid"));
        req.setValid(false);
        req.setBillid(bxmId);
        req.setAssetsId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"createid")));
        req.setEntrTicketId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"en_adid")));
        req.setEntrAssetsId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"en_cid")));
        req.setBidid((String)map.getFirst((Object)"bidid"));
        req.setObidid((String)map.getFirst((Object)"obidid"));
        req.setAdxAppId((String)map.getFirst((Object)"adx_appid"));
        req.setAdverCost((String)map.getFirst((Object)"adver_offer_price"));
        req.setCost(!StringUtils.equalsIgnoreCase((String)((String)map.getFirst((Object)"payed")), (String)"1"));
        ticket.setTime(new Date());
        ticket.setOfferPrice(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"offer_price")))));
        ticket.setBillid(bxmId);
        ticket.setUserBxmCount(TypeHelper.castToLong((Object)map.getFirst((Object)"seq")));
        ticket.setExploreType(this.getExploreType(map));
        this.asyncEventPark.post((EventObject)new TicketClickEvent(this, req, ticket));
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, map);
        this.asyncEventPark.post((EventObject)new TicketClickAsyncEvent(this, endpoint, ticket));
    }

    public Integer getExploreType(KeyValueMap keyValueMap) {
        Object value;
        block3: {
            String ext = (String)keyValueMap.getFirst((Object)"ext");
            if (StringUtils.isBlank((String)ext)) {
                return null;
            }
            value = null;
            try {
                Map map = InadsExtValueUtils.parse((String)ext);
                value = map.get("exb");
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("parseObject: '{}' on log: {}", (Object)e.getMessage(), (Object)keyValueMap);
            }
        }
        return TypeHelper.castToInt(value);
    }

    public static void main(String[] args) {
        String ext = "exb:1";
    }

    private Ticket get(String adid) {
        return (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), adid, Ticket.class);
    }
}

