/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.EffectEndpoint;
import com.bxm.adscounter.service.events.EffectEvent;
import com.bxm.adscounter.service.openlog.inads.event.AdConversionEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.adsprod.counter.event.TicketClickEvent;
import com.bxm.adsprod.counter.event.TicketEffectClickEvent;
import com.bxm.adsprod.facade.ticket.ClickRequest;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdConversionEventListener
implements EventListener<AdConversionEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdConversionEventListener.class);
    private final AsyncEventPark asyncEventPark;
    private final Fetcher fetcher;

    public AdConversionEventListener(AsyncEventPark asyncEventPark, Fetcher fetcher) {
        this.asyncEventPark = asyncEventPark;
        this.fetcher = fetcher;
    }

    @Subscribe
    public void consume(AdConversionEvent event) {
        KeyValueMap map = event.getLog();
        this.postEffectEvent(map);
        this.postTicketClickEvent(map);
    }

    private void postEffectEvent(KeyValueMap map) {
        EffectEndpoint endpoint = GeneralEndpointUtils.fromInads(map, 0);
        this.asyncEventPark.post((EventObject)new EffectEvent(this, endpoint));
    }

    private void postTicketClickEvent(KeyValueMap map) {
        String bxmId = (String)map.getFirst((Object)"bxmid");
        String adid = (String)map.getFirst((Object)"adid");
        if (StringUtils.isBlank((String)adid)) {
            log.warn("Not found adid: {}", (Object)bxmId);
            return;
        }
        Ticket ticket = this.get(adid);
        if (Objects.isNull(ticket)) {
            log.warn("Not found: {}", (Object)adid);
            return;
        }
        ClickRequest req = new ClickRequest();
        req.setUid((String)map.getFirst((Object)"uid"));
        req.setTicketId(TypeHelper.castToBigInteger((Object)adid));
        req.setPosition((String)map.getFirst((Object)"tagid"));
        req.setValid(true);
        req.setBillid(bxmId);
        req.setAssetsId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"createid")));
        req.setEntrTicketId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"en_adid")));
        req.setEntrAssetsId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"en_cid")));
        req.setBidid((String)map.getFirst((Object)"bidid"));
        req.setObidid((String)map.getFirst((Object)"obidid"));
        req.setAdxAppId((String)map.getFirst((Object)"adx_appid"));
        req.setCost(!StringUtils.equalsIgnoreCase((String)((String)map.getFirst((Object)"payed")), (String)"1"));
        req.setType(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"conversion_type")), (int)0)));
        ticket.setSettleType(Byte.valueOf(NumberUtils.toByte((String)((String)map.getFirst((Object)"settle_type")), (byte)ticket.getSettleType())));
        ticket.setCpaPrice(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"ocpa_offer_price")), (int)ticket.getCpaPrice())));
        ticket.setTime(new Date());
        ticket.setOfferPrice(Integer.valueOf(NumberUtils.toInt((String)((String)map.getFirst((Object)"offer_price")))));
        ticket.setBillid(bxmId);
        this.asyncEventPark.post((EventObject)new TicketClickEvent(this, req, ticket));
        this.asyncEventPark.post((EventObject)new TicketEffectClickEvent(this, req, ticket));
    }

    private Ticket get(String adid) {
        return (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), adid, Ticket.class);
    }
}

