/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adscounter.service.openlog.inads.listener;

import com.bxm.adscounter.model.DotTypeEnum;
import com.bxm.adscounter.model.GeneralEndpoint;
import com.bxm.adscounter.service.events.TicketShowEvent;
import com.bxm.adscounter.service.openlog.inads.event.AdShowEvent;
import com.bxm.adscounter.service.utils.GeneralEndpointUtils;
import com.bxm.adsprod.counter.event.TicketViewEvent;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.ViewRequest;
import com.bxm.openlog.sdk.KeyValueMap;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.bxm.warcar.utils.TypeHelper;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AdShowEventListener
implements EventListener<AdShowEvent> {
    private static final Logger log = LoggerFactory.getLogger(AdShowEventListener.class);
    private final Fetcher fetcher;
    private final AsyncEventPark asyncEventPark;

    public AdShowEventListener(Fetcher fetcher, AsyncEventPark asyncEventPark) {
        this.fetcher = fetcher;
        this.asyncEventPark = asyncEventPark;
    }

    @Subscribe
    public void consume(AdShowEvent event) {
        KeyValueMap map = event.getLog();
        String adid = (String)map.getFirst((Object)"adid");
        Ticket ticket = this.get(adid);
        if (Objects.isNull(ticket)) {
            log.warn("Not found: {}", (Object)adid);
            return;
        }
        ticket.setTime(new Date());
        ViewRequest req = new ViewRequest();
        req.setUid((String)map.getFirst((Object)"uid"));
        req.setTicketId(TypeHelper.castToBigInteger((Object)adid));
        req.setPosition((String)map.getFirst((Object)"tagid"));
        req.setAssetsId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"createid")));
        req.setEntrTicketId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"en_adid")));
        req.setEntrAssetsId(TypeHelper.castToBigInteger((Object)map.getFirst((Object)"en_cid")));
        req.setBidid((String)map.getFirst((Object)"bidid"));
        req.setObidid((String)map.getFirst((Object)"obidid"));
        req.setAdxAppId((String)map.getFirst((Object)"adx_appid"));
        this.asyncEventPark.post((EventObject)new TicketViewEvent(this, req, ticket));
        GeneralEndpoint endpoint = GeneralEndpointUtils.fromInads(DotTypeEnum.INTERACTIVE_ADS, map);
        this.asyncEventPark.post((EventObject)new TicketShowEvent(this, endpoint, ticket));
    }

    private Ticket get(String adid) {
        return (Ticket)this.fetcher.hfetch(TicketKeyGenerator.getAllTickets(), adid, Ticket.class);
    }
}

